/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanShowPlotTabAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.ui.menu.GissRadioButtonMenuItem;
import javax.swing.ButtonGroup;

public class PanViewPlotMenu
extends PanMenu {
    public PanViewPlotMenu(PanFrame parent) {
        super(parent, "view-plot-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        PanShowPlotTabAction a1 = null;
        PanShowPlotTabAction a2 = null;
        PanShowPlotTabAction a3 = null;
        if (parentIsPlot) {
            PanPlotFrame pframe = (PanPlotFrame)parent;
            a1 = new PanShowPlotTabAction(pframe, "show-plot", 0);
            a2 = new PanShowPlotTabAction(pframe, "show-array-1", 1);
            a3 = new PanShowPlotTabAction(pframe, "show-array-2", 2);
        }
        GissRadioButtonMenuItem mi1 = this.makeRadioButtonItemFromProperties("show-plot", a1);
        GissRadioButtonMenuItem mi2 = this.makeRadioButtonItemFromProperties("show-array-1", a2);
        GissRadioButtonMenuItem mi3 = this.makeRadioButtonItemFromProperties("show-array-2", a3);
        this.add(mi1).setEnabled(parentIsPlot);
        this.add(mi2).setEnabled(parentIsPlot);
        this.add(mi3).setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(mi1);
        bg.add(mi2);
        bg.add(mi3);
        this.addSeparator();
        GissRadioButtonMenuItem miArr = this.makeRadioButtonItemFromProperties("show-array-controls", null);
        GissRadioButtonMenuItem miScl = this.makeRadioButtonItemFromProperties("show-scale-controls", null);
        GissRadioButtonMenuItem miGrd = this.makeRadioButtonItemFromProperties("show-grid-controls", null);
        GissRadioButtonMenuItem miStr = this.makeRadioButtonItemFromProperties("show-stroke-controls", null);
        GissRadioButtonMenuItem miOvr = this.makeRadioButtonItemFromProperties("show-overlay-controls", null);
        GissRadioButtonMenuItem miShd = this.makeRadioButtonItemFromProperties("show-shading-controls", null);
        GissRadioButtonMenuItem miCnt = this.makeRadioButtonItemFromProperties("show-contour-controls", null);
        GissRadioButtonMenuItem miVec = this.makeRadioButtonItemFromProperties("show-vector-controls", null);
        GissRadioButtonMenuItem miLbL = this.makeRadioButtonItemFromProperties("show-label-controls", null);
        GissRadioButtonMenuItem miUnd = prefs.getBoolean("beta:underlays") ? this.makeRadioButtonItemFromProperties("show-underlay-controls", null) : null;
        GissRadioButtonMenuItem miNum = prefs.getBoolean("beta:numberlays") ? this.makeRadioButtonItemFromProperties("show-numberlay-controls", null) : null;
        this.add(miArr).setEnabled(false);
        this.add(miScl).setEnabled(false);
        this.add(miGrd).setEnabled(false);
        this.add(miOvr).setEnabled(false);
        this.add(miShd).setEnabled(false);
        this.add(miStr).setEnabled(false);
        this.add(miCnt).setEnabled(false);
        this.add(miVec).setEnabled(false);
        this.add(miLbL).setEnabled(false);
        if (miUnd != null) {
            this.add(miUnd).setEnabled(false);
        }
        if (miNum != null) {
            this.add(miNum).setEnabled(false);
        }
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(miArr);
        bgroup.add(miScl);
        bgroup.add(miGrd);
        bgroup.add(miOvr);
        bgroup.add(miShd);
        bgroup.add(miStr);
        bgroup.add(miCnt);
        bgroup.add(miVec);
        bgroup.add(miLbL);
        if (miUnd != null) {
            bgroup.add(miUnd);
        }
        if (miNum != null) {
            bgroup.add(miNum);
        }
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
    }
}

