/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanSaveSettingsToPrefsAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.menu.PanPlotHeightMenu;
import gov.nasa.giss.panoply.menu.PanPlotSizeMenu;
import gov.nasa.giss.panoply.menu.PanPlotWidthMenu;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.ui.menu.GissMenuItem;
import javax.swing.JCheckBoxMenuItem;

public class PanPlotMenu
extends PanMenu {
    public PanPlotMenu(PanFrame parent) {
        super(parent, "plot-menu");
        this.add(this.makeItemFromProperties("create-plot", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("plot-type", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("background", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("interpolate", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("reverse-scale", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("center-on-zero", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("fit-scale-to-data", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("fit-scale-to-clut", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("autofit-scale", null)).setEnabled(false);
        this.add(this.makeCheckBoxItemFromProperties("log-scale", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("link-dimensions", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("swap-xbounds", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("swap-ybounds", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("reset-bounds", null)).setEnabled(false);
        this.addSeparator();
        this.add(this.makeItemFromProperties("zoom-plot-in", null)).setEnabled(false);
        this.add(this.makeItemFromProperties("zoom-plot-out", null)).setEnabled(false);
        this.addSeparator();
        this.add(new PanPlotSizeMenu(parent));
        this.add(new PanPlotWidthMenu(parent));
        this.add(new PanPlotHeightMenu(parent));
        this.addSeparator();
        PanSaveSettingsToPrefsAction a = parent instanceof PanPlotFrame ? new PanSaveSettingsToPrefsAction((PanPlotFrame)parent) : null;
        GissMenuItem jmi = this.makeItemFromProperties("save-settings-to-prefs", a);
        this.add(jmi).setEnabled(a != null);
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private final void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame ppf = (PanPlotFrame)this.pframe_;
        PanPlotMeta pmeta = ppf.getMeta();
        if (pmeta == null) {
            return;
        }
        if (pmeta.get("type") == PanPlotType.LON_LAT) {
            boolean isMap;
            String lltype = pmeta.getString("lonlat.lltype");
            boolean bl = isMap = lltype.indexOf("Map") > -1;
            if (isMap) {
                String z2 = PanProperties.MENU_PROPS.getString("plot-type-z2");
                this.getItemByName("plot-type").setText(z2);
            } else {
                String m2 = PanProperties.MENU_PROPS.getString("plot-type-m2");
                this.getItemByName("plot-type").setText(m2);
            }
        }
        JCheckBoxMenuItem jcmi = (JCheckBoxMenuItem)this.getItemByName("interpolate");
        boolean canInterpolate = pmeta.containsKey("interpolate");
        jcmi.setEnabled(canInterpolate);
        if (canInterpolate) {
            jcmi.setSelected(pmeta.getBoolean("interpolate"));
        }
        if ((jcmi = (JCheckBoxMenuItem)this.getItemByName("reverse-scale")).getAction() == null) {
            jcmi.setEnabled(false);
        } else {
            boolean canReverse = pmeta.containsKey("scale.reverse");
            jcmi.setEnabled(canReverse);
            if (canReverse) {
                jcmi.setSelected(pmeta.getBoolean("scale.reverse"));
            }
        }
        PanScaleMethod smethod = PanScaleMethod.matching(pmeta.getString("scale.method"));
        boolean islog = smethod == PanScaleMethod.LOG10;
        ((JCheckBoxMenuItem)this.getItemByName("log-scale")).setSelected(islog);
    }
}

