/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiConstants;
import gov.nasa.giss.text.IntegerDocument;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanGribTableOptionsDialog
extends JDialog {
    private final PanFrame pframe_;
    private JTextField centerTF_;
    private JTextField subcenterTF_;
    private JTextField versionTF_;
    private JButton okayButton_;
    private JButton cancelButton_;
    private boolean success_;

    public PanGribTableOptionsDialog(PanFrame pframe) {
        super(pframe, "GRIB-1 Table Options", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
    }

    private final void createLayout() {
        MultiLineLabel messageLabel = new MultiLineLabel("Enter the center, subcenter and version for GRIB-1 datasets to which this table should be applied. Subcenter and version IDs may be set to the wildcard. Otherwise, all IDs should be between 1 and 255.", 72, 2);
        this.centerTF_ = new JTextField(new IntegerDocument(), "1", 6);
        this.subcenterTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.versionTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.centerTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setHorizontalAlignment(4);
        this.versionTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setMinimumSize(this.subcenterTF_.getPreferredSize());
        this.okayButton_ = new JButton("Okay");
        this.cancelButton_ = new JButton("Cancel");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelButton_, this.okayButton_) : QuickBox.createRightBox(this.okayButton_, this.cancelButton_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(4, 7, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiConstants.STD_BORDER);
        contentPanel.add((Component)messageLabel, new FGConstraint(0, 0, 4, 1, 1.0, 0.5));
        contentPanel.add((Component)new JLabel("Center: "), new FGConstraint(0, 2));
        contentPanel.add((Component)this.centerTF_, new FGConstraint(1, 2));
        contentPanel.add((Component)new JLabel("Subcenter: "), new FGConstraint(0, 3));
        contentPanel.add((Component)this.subcenterTF_, new FGConstraint(1, 3));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 3));
        contentPanel.add((Component)new JLabel("Version: "), new FGConstraint(0, 4));
        contentPanel.add((Component)this.versionTF_, new FGConstraint(1, 4));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 4));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 6, 4, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.okayButton_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private final void attachListeners() {
        this.okayButton_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelButton_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public int[] getResponses() {
        int c = ((IntegerDocument)this.centerTF_.getDocument()).getValue();
        int s = ((IntegerDocument)this.subcenterTF_.getDocument()).getValue();
        int v = ((IntegerDocument)this.versionTF_.getDocument()).getValue();
        return new int[]{c, s, v};
    }
}

