/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.data;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataLonLat
extends PanData2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanDataLonLat(NcArray nca, Dimension size) {
        this(nca, size.width, size.height);
    }

    public PanDataLonLat(NcArray nca, int w, int h) {
        super(nca, w, h);
        this.setLonLatBounds(LonLatBounds.ENTIRE_GLOBE);
    }

    @Override
    protected boolean validateArrayType(NcArray nca) {
        if (!(nca instanceof NcArrayLonLat)) {
            throw new IllegalArgumentException("NcArray is not NcArrayLonLat");
        }
        return true;
    }

    @Override
    public String getXAxisName() {
        return "Longitude";
    }

    @Override
    public String getXAxisUnits() {
        return "degree_east";
    }

    @Override
    public String getYAxisName() {
        return "Latitude";
    }

    @Override
    public String getYAxisUnits() {
        return "degree_north";
    }

    public boolean isGlobal() {
        if (this.tBound_ < 90.0 || this.bBound_ > -90.0) {
            return false;
        }
        return !(this.rBound_ - this.lBound_ < 360.0);
    }

    public double getGlobalMeanValue() {
        if (!this.isGlobal()) {
            return Double.NaN;
        }
        double yDegPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        double[] rowLats = new double[this.gridHeight_];
        for (int row = 0; row < this.gridHeight_; ++row) {
            rowLats[row] = this.tBound_ + ((double)row + 0.5) * yDegPerPxl;
        }
        double tweight = 0.0;
        double result = 0.0;
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rweight = Math.cos(Math.toRadians(rowLats[row]));
            for (int col = 0; col < this.gridWidth_; ++col) {
                double val = this.valueAt(col, row);
                if (Double.isNaN(val) || Double.isInfinite(val)) continue;
                result += val * rweight;
                tweight += rweight;
            }
        }
        if (tweight == 0.0) {
            return Double.NaN;
        }
        return result /= tweight;
    }

    public double getRowAverageValue(int row) {
        double result = 0.0;
        int count = 0;
        for (int col = 0; col < this.gridWidth_; ++col) {
            double val = this.valueAt(col, row);
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            result += val;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        if (count == 1) {
            return result;
        }
        return result /= (double)count;
    }

    public double getMinimumRowAverage() {
        double result = Double.MAX_VALUE;
        for (int j = 0; j < this.gridHeight_; ++j) {
            double rowAve = this.getRowAverageValue(j);
            if (Double.isNaN(rowAve)) continue;
            result = Math.min(result, rowAve);
        }
        return result;
    }

    public double getMaximumRowAverage() {
        double result = Double.MIN_VALUE;
        for (int j = 0; j < this.gridHeight_; ++j) {
            double rowAve = this.getRowAverageValue(j);
            if (Double.isNaN(rowAve)) continue;
            result = Math.max(result, rowAve);
        }
        return result;
    }

    public double getTopLat() {
        return this.tBound_;
    }

    public double getBottomLat() {
        return this.bBound_;
    }

    public final boolean setLonLatBounds(LonLatBounds bounds) {
        this.lBound_ = bounds.getWest();
        this.tBound_ = bounds.getNorth();
        this.rBound_ = bounds.getEast();
        this.bBound_ = bounds.getSouth();
        this.setBoundsChanged();
        return true;
    }

    @Override
    protected void prepareXGrid() {
    }

    @Override
    protected void prepareYGrid() {
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.gridWidth_ < 1 || this.gridHeight_ < 1) {
            return null;
        }
        double xPerPxl = (this.lBound_ - this.rBound_) / (double)this.gridWidth_;
        double yPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
        double xx = this.lBound_ + x * xPerPxl;
        double yy = this.tBound_ + y * yPerPxl;
        return new Point2D.Double(xx, yy);
    }

    public double valueAt(PointLL ll) {
        double lon;
        double lat = ll.getLat();
        for (lon = ll.getLon(); lon < this.lBound_; lon += 360.0) {
        }
        while (lon > this.rBound_) {
            lon -= 360.0;
        }
        int gridX = (int)((double)this.gridWidth_ * (lon - this.lBound_) / (this.rBound_ - this.lBound_));
        int gridY = (int)((double)this.gridHeight_ * (lat - this.tBound_) / (this.bBound_ - this.tBound_));
        return this.valueAt(gridX, gridY);
    }

    @Override
    public void describeDataAt(StringBuilder sb, int ii, int jj) {
        throw new UnsupportedOperationException("Use describeData(StringBuilder,PointLL) instead.");
    }

    public void describeDataAt(StringBuilder sb, PointLL ll) {
        double lon;
        Objects.requireNonNull(sb, "StringBuilder cannot be null.");
        double lat = ll.getLat();
        for (lon = ll.getLon(); lon < this.lBound_; lon += 360.0) {
        }
        while (lon > this.rBound_) {
            lon -= 360.0;
        }
        sb.append("Lon: ").append(PrintfFormat.PFORMAT_3.sprintg(lon)).append("\u00b0E").append('\n').append("Lat: ").append(PrintfFormat.PFORMAT_3.sprintg(lat)).append("\u00b0N").append('\n');
        sb.append("Displayed value: ");
        double dd = this.valueAt(ll);
        if (Double.isNaN(dd)) {
            sb.append("NaN");
        } else {
            sb.append(PrintfFormat.PFORMAT_7G.sprintg(dd));
        }
        sb.append("\n \n");
        for (int i = 0; i < 2; ++i) {
            if (this.ncArrays_[i] == null || i == 0 && this.combination_ == PanCombinationType.A2_ONLY || i == 1 && this.combination_ == PanCombinationType.A1_ONLY) continue;
            sb.append("Array ").append(i + 1).append(": ");
            NcArray nca = this.ncArrays_[i];
            int[] xy = ((NcArrayLonLat)((Object)nca)).getEnclosingCell(lon, lat);
            if (xy == null) {
                sb.append("Outside array bounds\n");
                continue;
            }
            nca.describeCell(sb, this.scaleFormatter_, xy);
            sb.append('\n');
        }
    }
}

