/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.cl;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.array.NcArray1D;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.PaperSize;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.ShapefileOverlay;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.data.PanData1D;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.overlay.PanMaskOverlay;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanAlphaMethod;
import gov.nasa.giss.panoply.util.PanAxisMethod;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanDevoMode;
import gov.nasa.giss.panoply.util.PanParameterKeys;
import gov.nasa.giss.panoply.util.PanPlotType;
import gov.nasa.giss.util.DescribedItem;
import java.awt.Color;
import java.io.File;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCLWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static String SYSTEM_EOL = System.getProperty("line.separator");
    private PanPreferences prefs_;
    private PanPlotMeta pmeta_;
    protected PanPlotType plotType_;
    protected PanCombinationType comboType_;
    protected PanData data_;
    protected String[] sources1_;
    protected String[] sources2_;

    public PCLWriter(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
        this.prefs_ = PanPreferences.getSharedInstance();
    }

    public synchronized void exportCLJavaScript(File f) {
        this.plotType_ = this.pmeta_.getType();
        this.data_ = this.pmeta_.getData();
        this.comboType_ = PanCombinationType.matching(this.pmeta_.getString("combination"));
        this.sources1_ = this.data_.getArraySource(0);
        this.sources2_ = this.data_.getArraySource(1);
        try {
            PrintWriter writer = new PrintWriter(f);
            this.sources1_[1] = this.sources1_[1].replace("\\", "\\\\");
            String fname = f.getName().replaceAll(" ", "\\\\ ");
            writer.write("// BETA BETA BETA");
            writer.write(SYSTEM_EOL);
            writer.write("// Script parsed by PanoplyCL to create a plot. Usage:");
            writer.write(SYSTEM_EOL);
            writer.write("// java -jar PanoplyCL.jar " + fname);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            LOGGER.trace("dataset  1 {}", (Object)this.sources1_[0]);
            LOGGER.trace("variable 1 {}", (Object)this.sources1_[1]);
            writer.write("// Open a dataset.");
            writer.write(SYSTEM_EOL);
            writer.format("var ncdata1 = panoply.openDataset ( \"%s\" );", this.sources1_[0]);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Select a variable.");
            writer.write(SYSTEM_EOL);
            writer.format("var ncvar1 = ncdata1.getVariable ( \"%s\" );", this.sources1_[1]);
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            writer.write("// Create the plot.");
            writer.write(SYSTEM_EOL);
            if (this.pmeta_.isLonLatZonal()) {
                writer.write("var myplot = panoply.createPlot ( \"zonal\", ncvar1 );");
            } else if (this.plotType_ == PanPlotType.GENERAL_2D) {
                PanData2D data2d = (PanData2D)this.data_;
                String xaxname = data2d.getXAxis().getName();
                String yaxname = data2d.getYAxis().getName();
                if (xaxname == null || yaxname == null) {
                    NcArray2D nca = (NcArray2D)data2d.getArrays()[0];
                    int xindex = nca.getXDimensionIndex();
                    int yindex = nca.getYDimensionIndex();
                    writer.write("// Axes dimensions are not named. Must identify them by index.");
                    writer.write(SYSTEM_EOL);
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, %d, %d );", PanPlotType.GENERAL_2D.getAbbreviation(), xindex + 1, yindex + 1);
                } else {
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, \"%s\", \"%s\" );", PanPlotType.GENERAL_2D.getAbbreviation(), xaxname, yaxname);
                }
            } else if (this.plotType_.isLinePlot()) {
                String ptypeStr = this.plotType_ == PanPlotType.HORZ_LINE ? PanPlotType.HORZ_LINE.getAbbreviation() : PanPlotType.VERT_LINE.getAbbreviation();
                PanData1D data1d = (PanData1D)this.data_;
                String axname = data1d.getAxisName();
                if (axname == null) {
                    NcArray1D nca = (NcArray1D)data1d.getArrays()[0];
                    int xindex = nca.getDimensionIndex();
                    writer.write("// Axis dimension is not named. Must identify it by index.");
                    writer.write(SYSTEM_EOL);
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, %d );", ptypeStr, xindex + 1);
                } else {
                    writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1, \"%s\" );", ptypeStr, axname);
                }
            } else {
                writer.format("var myplot = panoply.createPlot ( \"%s\", ncvar1 );", this.plotType_.getAbbreviation());
            }
            writer.write(SYSTEM_EOL);
            writer.write(SYSTEM_EOL);
            if (this.sources2_ != null) {
                LOGGER.trace("dataset 2  {}", (Object)this.sources2_[0]);
                LOGGER.trace("variable 2 {}", (Object)this.sources2_[1]);
                this.sources2_[1] = this.sources2_[1].replace("\\", "\\\\");
                if (this.sources2_[0].equals(this.sources1_[0]) && this.sources2_[1].equals(this.sources1_[1])) {
                    writer.write("// Second variable in combination plot is same as first.");
                    writer.write(SYSTEM_EOL);
                    writer.write("// Also add it to plot in second slot.");
                    writer.write(SYSTEM_EOL);
                    writer.write("myplot.setVariable ( 2, ncvar1 );");
                    writer.write(SYSTEM_EOL);
                } else {
                    if (this.sources2_[0].equals(this.sources1_[0])) {
                        writer.write("// Second variable in combination plot is in same dataset.");
                        writer.write("// Select second variable for combination plot.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncvar2 = ncdata1.getVariable ( \"%s\" );", this.sources2_[1]);
                        writer.write(SYSTEM_EOL);
                    } else {
                        writer.write("// Open dataset containing second var in combination plot.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncdata2 = panoply.openDataset ( \"%s\" );", this.sources2_[0]);
                        writer.write(SYSTEM_EOL);
                        writer.write(SYSTEM_EOL);
                        writer.write("// Select second variable.");
                        writer.write(SYSTEM_EOL);
                        writer.format("var ncvar2 = ncdata2.getVariable ( \"%s\" );", this.sources2_[1]);
                        writer.write(SYSTEM_EOL);
                    }
                    writer.write(SYSTEM_EOL);
                    writer.write("// Add second var to plot in second slot.");
                    writer.write(SYSTEM_EOL);
                    writer.write("myplot.setVariable ( 2, ncvar2 );");
                    writer.write(SYSTEM_EOL);
                }
                writer.write(SYSTEM_EOL);
                writer.write("// Combination of vars is '" + this.comboType_.getDescription() + "'\n");
                this.writeSetting(writer, "combination");
                writer.write(SYSTEM_EOL);
            }
            this.writeDimensions(writer);
            if (PanDevoMode.isDumpCLEnable()) {
                writer.write("// Dumping raw plot settings.");
                writer.write(SYSTEM_EOL);
                this.dumpSettings(writer);
            } else {
                writer.write("// Specify plot settings.");
                writer.write(SYSTEM_EOL);
                this.writeSettings(writer);
            }
            this.writeOutput(writer);
            writer.close();
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return;
        }
    }

    protected void writeDimensions(PrintWriter writer) {
        for (int i = 0; i < 2; ++i) {
            NcArray nca = this.data_.getArray(i);
            if (nca == null) continue;
            NcDimension[] freeDims = nca.getFreeDimensions();
            for (int j = 0; j < freeDims.length; ++j) {
                if (freeDims[j] == null) continue;
                int offset = nca.getSliceIndex(j);
                writer.format("// Variable #%d (%s), dim %d (%s) -- ", i + 1, nca.getShortName(), j + 1, freeDims[j].getName());
                if (offset == -1) {
                    writer.format("Set to average of %d steps", freeDims[j].getLength());
                    writer.write(SYSTEM_EOL);
                    writer.format("myplot.setVarDimension ( %d, %d, -1 );", i + 1, j + 1);
                    writer.write(SYSTEM_EOL);
                    continue;
                }
                writer.format("Set to step %d of %d", offset + 1, freeDims[j].getLength());
                writer.write(SYSTEM_EOL);
                writer.format("myplot.setVarDimension ( %d, %d, %d );", i + 1, j + 1, offset + 1);
                writer.write(SYSTEM_EOL);
            }
        }
        writer.write(SYSTEM_EOL);
        writer.flush();
    }

    private final void dumpSettings(PrintWriter writer) {
        writer.write("// DEVO DEVO DEVO DEVO DEVO");
        writer.write(SYSTEM_EOL);
        writer.write("// Dumping out **ALL** plot settings.");
        writer.write(SYSTEM_EOL);
        writer.write("// Order of settings is alphabetic and may be inappropriate");
        writer.write(SYSTEM_EOL);
        writer.write("// (i.e., some settings require that others be enabled first).");
        writer.write(SYSTEM_EOL);
        writer.write("// some settings are specific to GUI version of Panoply only.");
        writer.write(SYSTEM_EOL);
        for (String key : this.pmeta_.keySet()) {
            this.writeSetting(writer, key);
        }
        if (this.pmeta_.isLonLatMap()) {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            for (int i = 0; i < 5; ++i) {
                String k = "lonlat.proj.xparam." + (i + 1);
                Object s = projmeta.getXParamValue(i);
                if (s == null) continue;
                this.writeSetting(writer, k);
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private final void writeSettings(PrintWriter writer) {
        LOGGER.trace("");
        this.writeSetting(writer, "size.factor");
        this.writeSetting(writer, "size.width");
        this.writeSetting(writer, "size.height");
        writer.write(SYSTEM_EOL);
        if (PanDevoMode.isDevo5Point0()) {
            this.writeSetting(writer, "include.title");
            this.writeSetting(writer, "include.axes");
            this.writeSetting(writer, "include.scale");
            this.writeSetting(writer, "include.footnotes");
            this.writeSetting(writer, "include.margins");
            writer.write(SYSTEM_EOL);
        }
        this.writeSetting(writer, "font.master");
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "title.text");
        if (this.pmeta_.getString("subtitle.text").length() > 0) {
            this.writeSetting(writer, "subtitle.text");
        }
        if (PanDevoMode.isDevo5Point0()) {
            this.writeSetting(writer, "title.size");
            if (this.pmeta_.getString("subtitle.text").length() > 0) {
                this.writeSetting(writer, "subtitle.size");
            } else {
                this.writeSetting(writer, "subtitle.size", Float.valueOf(0.0f));
            }
        }
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "color.background");
        writer.write(SYSTEM_EOL);
        this.writeScaleSettings(writer);
        if (this.plotType_.isLinePlot()) {
            this.writeGridSettings(writer);
            if (this.plotType_ == PanPlotType.HORZ_LINE) {
                this.writeXAxisSettings(writer);
            } else {
                this.writeYAxisSettings(writer);
            }
            this.writeStrokeSettings(writer);
        } else if (this.pmeta_.isLonLatZonal()) {
            this.writeSetting(writer, "interpolate");
            writer.write(SYSTEM_EOL);
            this.writeGridSettings(writer);
            this.writeSetting(writer, "xaxis.left");
            this.writeSetting(writer, "xaxis.right");
            this.writeSetting(writer, "xaxis.div.major");
            this.writeSetting(writer, "xaxis.div.minor");
            this.writeSetting(writer, "xaxis.tick.format");
            writer.write(SYSTEM_EOL);
            this.writeStrokeSettings(writer);
        }
        if (this.pmeta_.isLonLatTrajectory()) {
            this.writeMapSettings(writer);
            this.writeGridSettings(writer);
            this.writeSetting(writer, "feature.background");
            this.writeSetting(writer, "feature.nanskip");
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_ID[0]);
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_SIZE[0]);
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_FILL[0]);
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_ID[1]);
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_SIZE[1]);
            this.writeSetting(writer, PanParameterKeys.FEATURE_SYMBOL_FILL[1]);
            writer.write(SYSTEM_EOL);
            this.writeStrokeSettings(writer);
        } else {
            this.writeSetting(writer, "interpolate");
            writer.write(SYSTEM_EOL);
            if (this.plotType_.isLonLatMap()) {
                this.writeMapSettings(writer);
                this.writeGridSettings(writer);
            } else {
                this.writeGridSettings(writer);
                this.writeXAxisSettings(writer);
                this.writeYAxisSettings(writer);
            }
            writer.write(SYSTEM_EOL);
            this.writeContourSettings(writer);
            this.writeVectorSettings(writer);
        }
        if (this.pmeta_.getString("footnote.left").length() > 0) {
            this.writeSetting(writer, "footnote.left");
        }
        if (this.pmeta_.getString("footnote.right").length() > 0) {
            this.writeSetting(writer, "footnote.right");
        }
        writer.write(SYSTEM_EOL);
        writer.flush();
    }

    private final void writeScaleSettings(PrintWriter writer) {
        if (this.pmeta_.getBoolean("scale.autofit")) {
            this.writeSetting(writer, "scale.autofit");
        } else {
            this.writeSetting(writer, "scale.min");
            this.writeSetting(writer, "scale.max");
        }
        this.writeSetting(writer, "scale.div.major");
        this.writeSetting(writer, "scale.div.minor");
        this.writeSetting(writer, "scale.exponent");
        this.writeSetting(writer, "scale.method");
        if (!this.pmeta_.getString("scale.units").equals("XXX")) {
            this.writeSetting(writer, "scale.units");
        }
        writer.write(SYSTEM_EOL);
        if (!this.plotType_.isLinePlot() && !this.pmeta_.isLonLatZonal()) {
            this.writeSetting(writer, "scale.colorbar");
            this.writeSetting(writer, "scale.invalids");
            this.writeSetting(writer, "scale.width");
            this.writeSetting(writer, "scale.reverse");
            this.writeSetting(writer, "scale.outlier.side");
            if (!PanColorbarOutlierSide.NONE.matches(this.pmeta_.getString("scale.outlier.side"))) {
                this.writeSetting(writer, "scale.outlier.shape");
                this.writeSetting(writer, "scale.outlier.gap");
            }
            this.writeSetting(writer, "scale.tick.size");
            this.writeSetting(writer, "scale.label.location");
        }
        this.writeSetting(writer, "scale.label.custom");
        if (this.pmeta_.getBoolean("scale.label.custom")) {
            this.writeSetting(writer, "scale.label.text");
        }
        this.writeSetting(writer, "scale.tick.format");
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "scale.minmax.note");
        this.writeSetting(writer, "scale.minmax.format");
        writer.write(SYSTEM_EOL);
    }

    private final void writeGridSettings(PrintWriter writer) {
        this.writeSetting(writer, "grid.weight");
        if (this.pmeta_.getInt("grid.weight") > 0) {
            this.writeSetting(writer, "grid.style");
            this.writeSetting(writer, "grid.color");
        }
        if (this.plotType_.isLinePlot()) {
            this.writeSetting(writer, "axes.offset");
        }
        writer.write(SYSTEM_EOL);
    }

    private final void writeXAxisSettings(PrintWriter writer) {
        if (this.plotType_ == PanPlotType.GENERAL_2D || this.plotType_.isLinePlot()) {
            this.writeSetting(writer, "xaxis.method");
            if (!PanAxisMethod.INDEX.matches(this.pmeta_.getString("xaxis.method"))) {
                this.writeSetting(writer, "xaxis.units");
            }
        }
        if (this.plotType_ != PanPlotType.TIME_LAT && this.plotType_ != PanPlotType.TIME_VERT) {
            this.writeSetting(writer, "xaxis.left");
            this.writeSetting(writer, "xaxis.right");
        }
        if (!PanAxisMethod.LOG10.matches(this.pmeta_.getString("xaxis.method"))) {
            this.writeSetting(writer, "xaxis.div.major");
            this.writeSetting(writer, "xaxis.div.minor");
        }
        this.writeSetting(writer, "xaxis.tick.format");
        this.writeSetting(writer, "xaxis.tick.size");
        this.writeSetting(writer, "xaxis.label.size");
        if (this.plotType_ == PanPlotType.GENERAL_2D || this.plotType_ == PanPlotType.TIME_LAT || this.plotType_ == PanPlotType.TIME_VERT || this.plotType_.isLinePlot()) {
            this.writeSetting(writer, "xaxis.label.custom");
            if (this.pmeta_.getBoolean("xaxis.label.custom")) {
                this.writeSetting(writer, "xaxis.label.text");
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private final void writeYAxisSettings(PrintWriter writer) {
        if (this.plotType_ == PanPlotType.GENERAL_2D || this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT || this.plotType_.isLinePlot()) {
            this.writeSetting(writer, "yaxis.method");
            if (!PanAxisMethod.INDEX.matches(this.pmeta_.getString("yaxis.method"))) {
                this.writeSetting(writer, "yaxis.units");
            }
            this.writeSetting(writer, "yaxis.bottom");
            this.writeSetting(writer, "yaxis.top");
        }
        if (!PanAxisMethod.LOG10.matches(this.pmeta_.getString("yaxis.method"))) {
            this.writeSetting(writer, "yaxis.div.major");
            this.writeSetting(writer, "yaxis.div.minor");
        }
        this.writeSetting(writer, "yaxis.tick.format");
        this.writeSetting(writer, "yaxis.tick.size");
        this.writeSetting(writer, "yaxis.label.size");
        if (this.plotType_ != PanPlotType.TIME_LAT) {
            this.writeSetting(writer, "yaxis.label.custom");
            if (this.pmeta_.getBoolean("yaxis.label.custom")) {
                this.writeSetting(writer, "yaxis.label.text");
            }
        }
    }

    private final void writeMapSettings(PrintWriter writer) {
        int i;
        this.writeSetting(writer, "lonlat.proj.name");
        this.writeSetting(writer, "lonlat.proj.lon0");
        this.writeSetting(writer, "lonlat.proj.lat0");
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        for (i = 0; i < 5; ++i) {
            String k = "lonlat.proj.xparam." + (i + 1);
            Object s = projmeta.getXParamValue(i);
            if (s == null) continue;
            this.writeSetting(writer, k);
        }
        writer.write(SYSTEM_EOL);
        if (this.pmeta_.getInt("grid.weight") > 0) {
            this.writeSetting(writer, "grid.spacing.lon");
            this.writeSetting(writer, "grid.spacing.lat");
            this.writeSetting(writer, "grid.offset.lat");
            this.writeSetting(writer, "grid.label.step");
            this.writeSetting(writer, "grid.label.size");
        }
        this.writeSetting(writer, "lonlat.border.weight");
        writer.write(SYSTEM_EOL);
        for (i = 0; i < 3; ++i) {
            if (this.pmeta_.get(PanParameterKeys.LON_LAT_OVERLAY_NAME[i]) == null) {
                this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i], 0);
                continue;
            }
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i]);
            if (this.pmeta_.getInt(PanParameterKeys.LON_LAT_OVERLAY_WEIGHT[i]) <= 0) continue;
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_NAME[i]);
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_COLOR[i]);
            if (this.pmeta_.get(PanParameterKeys.LON_LAT_OVERLAY_NAME[i]) instanceof PanMaskOverlay) {
                this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_INVERT[i]);
                continue;
            }
            if (!(this.pmeta_.get(PanParameterKeys.LON_LAT_OVERLAY_NAME[i]) instanceof ShapefileOverlay)) continue;
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_STYLE[i]);
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_ID[i]);
            this.writeSetting(writer, PanParameterKeys.LON_LAT_OVERLAY_SYMBOL_SIZE[i]);
        }
        writer.write(SYSTEM_EOL);
        this.writeSetting(writer, "lonlat.proj.shading.vis");
        if (this.pmeta_.getBoolean("lonlat.proj.shading.vis")) {
            this.writeSetting(writer, "lonlat.proj.shading.opacity");
            this.writeSetting(writer, "lonlat.proj.subsolar.lon");
            this.writeSetting(writer, "lonlat.proj.subsolar.lat");
        }
        writer.write(SYSTEM_EOL);
        if (this.prefs_.getBoolean("beta:underlays")) {
            boolean ulayEnabled = this.pmeta_.getBoolean("lonlat.underlay.vis");
            String uname = this.pmeta_.getString("lonlat.underlay.name");
            int alphaCount = 0;
            if ("NONE".equals(uname.toUpperCase())) {
                ulayEnabled = false;
            } else {
                PanAlphaMethod am = PanAlphaMethod.matching(this.pmeta_.getString("main.alpha.method"));
                alphaCount = am.getAlphaCount();
            }
            this.writeSetting(writer, "lonlat.underlay.vis");
            if (ulayEnabled) {
                this.writeSetting(writer, "lonlat.underlay.name");
                this.writeSetting(writer, "main.alpha.method");
                this.writeSetting(writer, "main.alpha.1");
                if (alphaCount > 1) {
                    this.writeSetting(writer, "main.alpha.2");
                }
                this.writeSetting(writer, "main.alpha.knockout");
            }
            writer.write(SYSTEM_EOL);
        }
        if (this.prefs_.getBoolean("beta:numberlays")) {
            this.writeSetting(writer, "lonlat.numbers.vis");
            if (this.pmeta_.getBoolean("lonlat.numbers.vis")) {
                this.writeSetting(writer, "lonlat.numbers.spacing.lon");
                this.writeSetting(writer, "lonlat.numbers.spacing.lat");
                this.writeSetting(writer, "lonlat.numbers.offset.lon");
                this.writeSetting(writer, "lonlat.numbers.offset.lat");
                this.writeSetting(writer, "lonlat.numbers.size");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private final void writeContourSettings(PrintWriter writer) {
        if (this.pmeta_.containsKey("contour.weight")) {
            if (this.pmeta_.getInt("contour.weight") == 0 || this.pmeta_.getString("contour.style").equalsIgnoreCase("none")) {
                this.writeSetting(writer, "contour.weight", 0);
            } else {
                this.writeSetting(writer, "contour.weight");
                this.writeSetting(writer, "contour.style");
                this.writeSetting(writer, "contour.color");
                this.writeSetting(writer, "contour.location");
                this.writeSetting(writer, "contour.label.vis");
                this.writeSetting(writer, "contour.label.size");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private final void writeVectorSettings(PrintWriter writer) {
        if (this.comboType_ == PanCombinationType.VECTOR && this.pmeta_.containsKey("vector.weight")) {
            if (this.pmeta_.getInt("vector.weight") == 0 || this.pmeta_.getString("vector.style").equalsIgnoreCase("none")) {
                this.writeSetting(writer, "vector.weight", 0);
            } else {
                this.writeSetting(writer, "vector.weight");
                this.writeSetting(writer, "vector.style");
                this.writeSetting(writer, "vector.color");
                this.writeSetting(writer, "vector.spacing");
                this.writeSetting(writer, "vector.dir1");
                this.writeSetting(writer, "vector.dir2");
                this.writeSetting(writer, "vector.sample");
                this.writeSetting(writer, "vector.refvalue");
            }
            writer.write(SYSTEM_EOL);
        }
    }

    private final void writeStrokeSettings(PrintWriter writer) {
        this.writeSetting(writer, PanParameterKeys.STROKE_WEIGHT[0]);
        this.writeSetting(writer, PanParameterKeys.STROKE_COLOR[0]);
        this.writeSetting(writer, PanParameterKeys.STROKE_STYLE[0]);
        this.writeSetting(writer, PanParameterKeys.STROKE_LABEL_CUSTOM[0]);
        if (this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[0])) {
            this.writeSetting(writer, PanParameterKeys.STROKE_LABEL_TEXT[0]);
        }
        if (this.sources2_ != null && (this.comboType_ == PanCombinationType.COMPARE || this.pmeta_.isLonLatTrajectory())) {
            this.writeSetting(writer, PanParameterKeys.STROKE_WEIGHT[1]);
            this.writeSetting(writer, PanParameterKeys.STROKE_COLOR[1]);
            this.writeSetting(writer, PanParameterKeys.STROKE_STYLE[1]);
            this.writeSetting(writer, PanParameterKeys.STROKE_LABEL_CUSTOM[1]);
            if (this.pmeta_.getBoolean(PanParameterKeys.STROKE_LABEL_CUSTOM[1])) {
                this.writeSetting(writer, PanParameterKeys.STROKE_LABEL_TEXT[1]);
            }
        }
        writer.write(SYSTEM_EOL);
    }

    private final void writeSetting(PrintWriter writer, String pkey) {
        Object pvalue = null;
        if (!this.pmeta_.containsKey(pkey)) {
            LOGGER.warn("'{}' is not a known key for plot type {}", (Object)pkey, (Object)this.plotType_);
            return;
        }
        pvalue = this.pmeta_.get(pkey);
        this.writeSetting(writer, pkey, pvalue);
    }

    private final void writeSetting(PrintWriter writer, String pkey, Object pvalue) {
        String xpkey = pkey;
        String svalue = null;
        svalue = pvalue == null ? "NONE" : (pvalue instanceof String || pvalue instanceof AbstractColorTable || pvalue instanceof MapOverlay ? "\"" + pvalue + "\"" : (pvalue instanceof Color ? "\"" + ColorUtils.colorToString((Color)pvalue) + "\"" : (pvalue instanceof Integer || pvalue instanceof Double || pvalue instanceof Float ? pvalue.toString() : (pvalue instanceof Boolean ? pvalue.toString() : (pvalue instanceof DescribedItem ? "\"" + ((DescribedItem)pvalue).name().toString().toUpperCase() + "\"" : "\"" + pvalue.toString() + "\"")))));
        if (xpkey.startsWith("lonlat.zonal.")) {
            xpkey = xpkey.replaceFirst("lonlat.zonal.", "");
        } else if (pkey.startsWith("lonlat.")) {
            xpkey = xpkey.replaceFirst("lonlat.", "");
        }
        xpkey = xpkey.replaceAll("\\.", "-");
        writer.format("myplot.set ( \"%s\", %s );", xpkey, svalue);
        writer.write(SYSTEM_EOL);
    }

    private final void writeOutput(PrintWriter writer) {
        String ucExt = this.prefs_.getString("files:save.image.extension").toUpperCase();
        PanPlotFrame pframe = this.pmeta_.getFrame();
        String pname = pframe != null ? pframe.getTitle().replaceAll("\\s", "_") : "PanoplyPlot";
        writer.write("// Save plot image to disk.");
        writer.write(SYSTEM_EOL);
        if (ucExt.equals("PDF") || ucExt.equals("PS")) {
            boolean vectorized = this.prefs_.getBoolean("files:save.pspdf.vectorized");
            PaperSize pps = PaperSize.matching(this.prefs_.getString("files:save.pspdf.paper"));
            writer.format("myplot.saveImage ( \"%s\", \"%s.%s\", %s, \"%s\" );", ucExt, pname, ucExt.toLowerCase(), vectorized, pps.name());
        } else {
            writer.format("myplot.saveImage ( \"%s\", \"%s.%s\" );", ucExt, pname, ucExt.toLowerCase());
        }
        writer.write(SYSTEM_EOL);
    }
}

