/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.bookmarks;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.bookmarks.PanBookmark;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkList;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkType;
import gov.nasa.giss.panoply.bookmarks.PanHistoryFolder;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.time.LocalDate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanHistoryList
extends PanBookmarkList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PanHistoryList getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanHistoryList() {
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return "history";
    }

    @Override
    public String getAddress() {
        return "history";
    }

    @Override
    public void add(TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(index, child);
    }

    public void enforceAgeLimit(int limit) {
        PanHistoryFolder hf;
        int xlimit = limit;
        if (xlimit < 0) {
            xlimit = 60;
            LOGGER.warn("History age limit less than 0. Using 60 days instead.");
        }
        TreeTableNode[] children = this.getChildren();
        for (int i = children.length - 1; i >= 0 && (hf = (PanHistoryFolder)children[i]).getAge() > xlimit; --i) {
            this.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(NcDataset ncd) {
        PanBookmark b;
        block8: {
            Objects.requireNonNull(ncd, "NcDataset is null.");
            URL url = ncd.getURL();
            String prot = url.getProtocol();
            b = null;
            try {
                if ("file".equals(prot)) {
                    b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)url, null);
                    break block8;
                }
                if ("http".equals(prot) || "https".equals(prot) || "ftp".equals(prot)) {
                    b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)url, null);
                    break block8;
                }
                throw new RuntimeException("Dataset access protocol not understood");
            }
            catch (Exception exc) {
                LOGGER.warn("Couldn't add bookmark due to {}", exc);
            }
        }
        if (b == null) {
            LOGGER.debug("Somehow, bookmark is null");
            return;
        }
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            this.addBookmark(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(NcCatalog c) {
        Objects.requireNonNull(c, "Catalog is null.");
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            try {
                PanBookmark b = new PanBookmark(PanBookmarkType.CATALOG, (Object)c.getURI(), null);
                this.addBookmark(b);
            }
            catch (Exception exc) {
                LOGGER.warn("Couldn't add bookmark for {}", (Object)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(PanBookmark b) {
        Objects.requireNonNull(b, "Bookmark is null.");
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            PanHistoryFolder folder = this.getTodayFolder();
            folder.add(0, b);
            b.setParent(folder);
        }
    }

    public PanHistoryFolder getTodayFolder() {
        PanHistoryFolder hf;
        if (this.getChildCount() > 0 && (hf = (PanHistoryFolder)this.getChildAt(0)).isTodayFolder()) {
            return hf;
        }
        LocalDate offsetLDT = LocalDate.now();
        int year = offsetLDT.getYear();
        int month = offsetLDT.getMonthValue();
        int day = offsetLDT.getDayOfMonth();
        PanHistoryFolder folder = new PanHistoryFolder(this, year, month, day);
        this.add(0, folder);
        return folder;
    }

    private static class Singleton {
        private static final PanHistoryList INSTANCE = new PanHistoryList();

        private Singleton() {
        }
    }
}

