/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plotui.PanControlsTabbedPane;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotTabbedPane;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class PanShowPlotTabAction
extends AbstractAction {
    private final PanPlotFrame parent_;
    private final String actionName_;
    private final int tabIndex_;

    public PanShowPlotTabAction(PanPlotFrame parent, String actionName, int tabIndex) {
        this.parent_ = parent;
        this.actionName_ = actionName;
        this.tabIndex_ = tabIndex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanMenuBar mbar;
        PanControlsTabbedPane ctpane;
        PanPlotTabbedPane ptpane = this.parent_.getTopTabbedPane();
        if (ptpane != null) {
            ptpane.setSelectedIndex(this.tabIndex_);
        }
        if ((ctpane = this.parent_.getControlsTabbedPane()) != null) {
            ctpane.refresh();
        }
        if ((mbar = this.parent_.getPanMenuBar()) == null) {
            return;
        }
        GissMenu viewPMenu = mbar.getMenuByName("view-plot-menu");
        if (viewPMenu == null) {
            return;
        }
        JMenuItem item = viewPMenu.getItemByName(this.actionName_);
        if (item != null) {
            ((JRadioButtonMenuItem)item).setSelected(true);
        }
    }
}

