/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.bookmarks.PanBookmark;
import gov.nasa.giss.panoply.bookmarks.PanBookmarkType;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanAddBookmarkAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanSourcesFrame parent_;

    public PanAddBookmarkAction(PanSourcesFrame f) {
        super(PanProperties.MENU_PROPS.getString("add-bookmark"));
        this.parent_ = f;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PanBookmark b;
        block18: {
            TreeTableNode node = this.parent_.getSelectedNode();
            if (node == null) {
                return;
            }
            b = null;
            if (node instanceof NcDataNode) {
                if (!(node instanceof NcDataset)) {
                    return;
                }
                NcDataset ncd = (NcDataset)node;
                URL url = ncd.getURL();
                String prot = url.getProtocol();
                try {
                    if ("file".equals(prot)) {
                        b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)url, null);
                        break block18;
                    }
                    if ("http".equals(prot) || "https".equals(prot) || "ftp".equals(prot)) {
                        b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)url, null);
                        break block18;
                    }
                    throw new RuntimeException("Dataset access protocol not understood.");
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else if (node instanceof NcCatalog) {
                NcCatalog cc = (NcCatalog)node;
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cc.getURI(), cc.getName());
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else if (node instanceof NcCatalogDataset) {
                NcCatalogDataset cd = (NcCatalogDataset)node;
                if (!cd.getAllowsChildren()) {
                    return;
                }
                try {
                    b = new PanBookmark(PanBookmarkType.CATALOG, (Object)cd.getCatalogURL(), cd.getName());
                }
                catch (Exception exc) {
                    LOGGER.warn("Bad bookmark : {}", (Object)exc.toString());
                }
            } else {
                return;
            }
        }
        if (b == null) {
            return;
        }
        PanSourcesFrame.getSharedInstance().addBookmarksNode(b);
        GuiUtils.refreshFrontFrameMenuBar();
    }
}

