/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class WinkelSnyder
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Winkel-Snyder";
    private static final double COS_PHI1 = 0.6366197723675814;
    private static final double WIDTH_FACTOR = 2.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;

    public WinkelSnyder(int width, int height) {
        this(width, height, 0, 0);
    }

    public WinkelSnyder(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public WinkelSnyder(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.5707963267948966, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.5707963267948966 * this.rS_);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.5707963267948966 * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = this.iterateThetaFromPhi(phiRad);
        double y = 0.25 * (Math.PI * Math.sin(thetaRad) + 2.0 * phiRad);
        double x = 0.5 * this.lonToLambdaRad(lon) * (Math.cos(thetaRad) + 0.6366197723675814);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double phiRad = this.iteratePhiFromYRS(yOverRS, 1.5707963267948966 * y / (double)this.dyMax_);
        double thetaRad = this.iterateThetaFromPhi(phiRad);
        double cosTheta = Math.cos(thetaRad);
        double lambdaRad = 2.0 * xOverRS / (cosTheta + 0.6366197723675814);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        WinkelSnyder winkelSnyder = this;
        synchronized (winkelSnyder) {
            double phiRad = 0.05;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                phiRad = this.iteratePhiFromYRS(yOverRS, phiRad);
                double thetaRad = this.iterateThetaFromPhi(phiRad);
                double cosTheta = Math.cos(thetaRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = 2.0 * (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / (cosTheta + 0.6366197723675814)) > Math.PI); ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double iterateThetaFromPhi(double phiRad) {
        if (phiRad > 1.5707863267948965 || phiRad < -1.5707863267948965) {
            return phiRad;
        }
        if (Math.abs(phiRad) < 1.0E-10) {
            return 0.0;
        }
        double sinPhi = Math.sin(phiRad);
        double piSinPhi = Math.PI * sinPhi;
        double thetaRad = 0.9 * phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        return thetaRad;
    }

    private double iteratePhiFromYRS(double yOverRS, double firstGuess) {
        double phiRad = firstGuess;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double piCosPhi = Math.PI * Math.cos(phiRad);
            double thetaRad = this.iterateThetaFromPhi(phiRad);
            double twoThetaRad = 2.0 * thetaRad;
            double cosTheta = Math.cos(thetaRad);
            double sinTheta = Math.sin(thetaRad);
            double dthetaRad = piCosPhi / (2.0 + 2.0 * Math.cos(twoThetaRad));
            double func = 0.25 * (Math.PI * sinTheta + 2.0 * phiRad) - yOverRS;
            double dfunc = 0.25 * (Math.PI * cosTheta * dthetaRad + 2.0);
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (found) {
            return phiRad;
        }
        return Double.NaN;
    }
}

