/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class Wiechel
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Wiechel";
    public static final int PROPERTIES = 0x200080;
    private static final double DEFAULT_RADIUS = 90.0;
    private static final double MAX_RADIUS = 180.0;
    protected static final double MIN_RADIUS = 1.0E-4;
    protected double cosPhiC_;
    protected double sinPhiC_;
    private double radiusDeg_ = 90.0;
    private double radiusRad_;
    protected double rhoBorder_;
    private double rhoBorder2_;
    private final Arc2D.Double arc_ = new Arc2D.Double();
    private double extraRotRad_;
    private boolean fillCorners_;
    private ProjDoubleParameter edgeParam_ = new ProjDoubleParameter("Angle between center and nearest edge of map", "Edge Radius", "\u00b0 (\u2264180.0\u00b0)", 90.0, 1.0E-4, 180.0, true, true);
    private ProjDoubleParameter rotateParam_;
    private ProjBooleanParameter fillParam_;

    public Wiechel(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wiechel(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Wiechel(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200080, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addParameter(this.edgeParam_);
        this.rotateParam_ = new ProjDoubleParameter("Additional rotation (clockwise)", "Add'l rotation", "\u00b0", 0.0, -180.0, 180.0, true, true);
        this.addParameter(this.rotateParam_);
        this.fillParam_ = new ProjBooleanParameter("Map is not limited to purely circular area", "Fill corners", true);
        this.addParameter(this.fillParam_);
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setEdgeRadius(this.edgeParam_.getValue());
            this.setFillCorners(this.fillParam_.isSelected());
            this.setExtraRotation(this.rotateParam_.getValue());
        } else if (p == this.edgeParam_) {
            this.setEdgeRadius(this.edgeParam_.getValue());
        } else if (p == this.fillParam_) {
            this.setFillCorners(this.fillParam_.isSelected());
        } else if (p == this.rotateParam_) {
            this.setExtraRotation(this.rotateParam_.getValue());
        } else {
            throw new IllegalArgumentException("Unknown parameter");
        }
    }

    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.autoscale();
    }

    public void setExtraRotation(double r) {
        this.extraRotRad_ = Math.toRadians(r);
        this.autoscale();
    }

    public void setFillCorners(boolean fill) {
        this.fillCorners_ = fill;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double rhoMaxOverR = 1.4142135623730951 * Math.sqrt(1.0 - Math.cos(this.radiusRad_));
        this.setSizeFactor(rhoMaxOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = 2.0;
            this.rhoBorder_ = 2.0 * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double rho2;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ == -1.0) {
            return null;
        }
        double z = Math.acos(cosZ);
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(z) > 1.0E-5) {
            double k = Math.sqrt(2.0 / (1.0 + cosZ));
            double xP = k * cosPhi * Math.sin(lambdaRad);
            double yP = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
            double zz = 0.5 * z + this.extraRotRad_;
            double cosZZ = Math.cos(zz);
            double sinZZ = Math.sin(zz);
            x = xP * cosZZ + yP * sinZZ;
            y = -xP * sinZZ + yP * cosZZ;
        }
        if ((rho2 = x * x + y * y) * this.r2s2_ > this.rhoBorder2_) {
            return null;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return this.getCenter();
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = 2.0 * Math.asin(rho * 0.5 * this.invRS_);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double zz = 0.5 * z + this.extraRotRad_;
        double cosZZ = Math.cos(zz);
        double sinZZ = Math.sin(zz);
        double xP = x * cosZZ - y * sinZZ;
        double yP = x * sinZZ + y * cosZZ;
        double phiRad = Math.asin(cosZ * this.sinPhiC_ + yP * sinZ * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(xP * sinZ, rho * this.cosPhiC_ * cosZ - yP * this.sinPhiC_ * sinZ);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wiechel wiechel = this;
        synchronized (wiechel) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > this.rhoBorder2_) continue;
                    double rho = Math.sqrt(rho2);
                    double z = 2.0 * Math.asin(rho * 0.5 * this.invRS_);
                    double sinZ = Math.sin(z);
                    double cosZ = Math.cos(z);
                    double zz = 0.5 * z + this.extraRotRad_;
                    double cosZZ = Math.cos(zz);
                    double sinZZ = Math.sin(zz);
                    double xP = x * cosZZ - y * sinZZ;
                    double yP = x * sinZZ + y * cosZZ;
                    double phiRad = Math.asin(cosZ * this.sinPhiC_ + yP * sinZ * this.cosPhiC_ / rho);
                    double lambdaRad = Math.atan2(xP * sinZ, rho * this.cosPhiC_ * cosZ - yP * this.sinPhiC_ * sinZ);
                    this.setPoint(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private void setPoint(int ix, int iy, double dlambda, double phi) {
        int srcX;
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = this.lambdaC_ + dlambda;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        this.drawCircle(g2d, this.rhoBorder_, true);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            if (Math.abs(this.phiC_ - lat) >= this.radiusDeg_ && !this.fillCorners_) {
                return;
            }
            double phiRad = Math.toRadians(lat);
            double sinPhi = Math.sin(phiRad);
            double rho = this.rS_ * Math.sqrt(2.0 * (1.0 - sinPhi));
            this.drawCircle(g2d, rho, false);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    private void drawCircle(Graphics2D g2d, double radius, boolean link) {
        double r2 = radius * radius;
        double w2 = this.dxMax_ * this.dxMax_;
        double h2 = this.dyMax_ * this.dyMax_;
        double rhoCorner = Math.sqrt(w2 + h2);
        g2d.translate(this.outCenterX_, this.outCenterY_);
        if (radius <= (double)this.dxMax_ && radius <= (double)this.dyMax_) {
            ProjectionUtils.drawEllipse(g2d, 0.0, 0.0, radius, radius);
        } else if (radius > rhoCorner) {
            if (link) {
                ProjectionUtils.drawRect(g2d, -this.dxMax_, -this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
            }
        } else if (radius > (double)this.dxMax_ && radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(this.dxMax_, -dyy);
                path.lineTo(this.dxMax_, dyy);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                path.moveTo(-this.dxMax_, dyy);
                path.lineTo(-this.dxMax_, -dyy);
                g2d.draw(path);
            }
            double angle1 = -Math.toDegrees(Math.acos(dxx / radius));
            double angle2 = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double arc = Math.abs(angle1 + angle2);
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, -angle1, -arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle1, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 - angle1, -arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.dyMax_) {
            double dxx = Math.sqrt(r2 - h2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-dxx, -this.dyMax_);
                path.lineTo(dxx, -this.dyMax_);
                path.moveTo(dxx, this.dyMax_);
                path.lineTo(-dxx, this.dyMax_);
                g2d.draw(path);
            }
            double angle = -Math.toDegrees(Math.acos(dxx / radius));
            double arc = -2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        } else if (radius > (double)this.dxMax_) {
            double dyy = Math.sqrt(r2 - w2);
            if (link) {
                Path2D.Double path = new Path2D.Double();
                path.moveTo(-this.dxMax_, -dyy);
                path.lineTo(-this.dxMax_, dyy);
                path.moveTo(this.dxMax_, dyy);
                path.lineTo(this.dxMax_, -dyy);
                g2d.draw(path);
            }
            double angle = 90.0 - Math.toDegrees(Math.acos(dyy / radius));
            double arc = 180.0 - 2.0 * angle;
            this.arc_.setArcByCenter(0.0, 0.0, radius, angle, arc, 0);
            g2d.draw(this.arc_);
            this.arc_.setArcByCenter(0.0, 0.0, radius, 180.0 + angle, arc, 0);
            g2d.draw(this.arc_);
        }
        g2d.translate(-this.outCenterX_, -this.outCenterY_);
    }
}

