/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.EllipseProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class VanDerGrinten1
extends EllipseProjection {
    public static final String PROJECTION_NAME = "Van der Grinten I";
    public static final int PROPERTIES = 32;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.PI;
    protected double rhoBorder_;
    private double rhoBorder2_;

    public VanDerGrinten1(int width, int height) {
        this(width, height, 0, 0);
    }

    public VanDerGrinten1(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public VanDerGrinten1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, Math.PI);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.xmRS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        if (absLat < 1.0E-5) {
            double x = lambdaRad;
            double y = 0.0;
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        if (absLat > 89.99999) {
            double x = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double phiRad = Math.toRadians(absLat);
        double sinTheta = phiRad * 0.6366197723675814;
        double cosTheta = Math.sqrt(1.0 - sinTheta * sinTheta);
        if (lambdaRad == 0.0) {
            double y1 = sinTheta / (1.0 + cosTheta);
            double x = 0.0;
            double y = Math.PI * y1;
            if (lat < 0.0) {
                y = -y;
            }
            x = (double)this.outCenterX_ + x * this.rS_;
            y = (double)this.outCenterY_ - y * this.rS_;
            return new Point2D.Double(x, y);
        }
        double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad * 0.3183098861837907);
        double a2 = a * a;
        double g = cosTheta / (sinTheta + cosTheta - 1.0);
        double p = g * (2.0 / sinTheta - 1.0);
        double q = a2 + g;
        double p2 = p * p;
        double s = p2 + a2;
        double t = g - p2;
        double x = Math.PI * (a * t + Math.sqrt(a2 * t * t - s * (g * g - p2))) / s;
        double y = Math.PI * (p * q - a * Math.sqrt((a2 + 1.0) * s - q * q)) / s;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double absY;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double absX = Math.abs(x);
        double[] llRad = this.transformXaYa2LL(absX, absY = Math.abs(y));
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        VanDerGrinten1 vanDerGrinten1 = this;
        synchronized (vanDerGrinten1) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double[] llRad;
                double x;
                double rho2;
                double y = (double)iy + 0.5;
                for (int ix = 0; ix < this.dxMax_ && !((rho2 = (x = (double)ix + 0.5) * x + y * y) > this.rhoBorder2_) && (llRad = this.transformXaYa2LL(x, y)) != null; ++ix) {
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(llRad[0]), Math.toDegrees(llRad[1]));
                }
            }
        }
    }

    private double[] transformXaYa2LL(double x, double y) {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        if (y * y + x * x > rhoMax2) {
            return null;
        }
        double invPiRS = this.invRS_ * 0.3183098861837907;
        double capY = y * invPiRS;
        double capY2 = capY * capY;
        double capX = x * invPiRS;
        double capX2 = capX * capX;
        double capX2pY2 = capX2 + capY2;
        double lambdaRad = 0.0;
        if (capX != 0.0) {
            lambdaRad = 1.5707963267948966 * (capX2pY2 - 1.0 + Math.sqrt(1.0 + 2.0 * (capX2 - capY2) + capX2pY2 * capX2pY2)) / capX;
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        double c1 = -Math.abs(capY) * (1.0 + capX2pY2);
        double c2 = c1 - 2.0 * capY2 + capX2;
        double c3 = -2.0 * c1 + 1.0 + 2.0 * capY2 + capX2pY2 * capX2pY2;
        double d = capY2 / c3 + (2.0 * c2 * c2 * c2 / c3 - 9.0 * c1 * c2) / (27.0 * c3 * c3);
        double a1 = (c1 - c2 * c2 / (3.0 * c3)) / c3;
        double m1 = 2.0 * Math.sqrt(-a1 / 3.0);
        double theta1 = Math.acos(3.0 * d / (a1 * m1)) / 3.0;
        double phiRad = Math.PI * (-m1 * Math.cos(theta1 + 1.0471975511965976) - c2 / (3.0 * c3));
        return new double[]{lambdaRad, phiRad};
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(lat) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, (double)this.outCenterX_ - this.rhoBorder_, this.outCenterY_, (double)this.outCenterX_ + this.rhoBorder_, this.outCenterY_);
        } else {
            double llon = this.lambdaC_ + -179.99999;
            double rlon = this.lambdaC_ + 179.99999;
            Point2D.Double dot1 = this.transformLL2XY(llon, lat);
            Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_, lat);
            Point2D.Double dot3 = this.transformLL2XY(rlon, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambda = Math.abs(lambdaRad);
        if (absLambda > 179.99999) {
            return;
        }
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, this.outCenterX_, (double)this.outCenterY_ - this.rhoBorder_, this.outCenterX_, (double)this.outCenterY_ + this.rhoBorder_);
        } else {
            double dxEqu = this.rhoBorder_ * lambdaRad * 0.3183098861837907;
            GraphicUtils.drawCircularArc(g2d, this.outCenterX_, (double)this.outCenterY_ - this.rhoBorder_, (double)this.outCenterX_ + dxEqu, this.outCenterY_, this.outCenterX_, (double)this.outCenterY_ + this.rhoBorder_);
        }
    }
}

