/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;

public abstract class TwoHemisphereAzimuthalProjection
extends AbstractProjection {
    public static final int PROPERTIES = 44040256;
    protected static final double MIN_RADIUS = 1.0E-4;
    private final double radiusFactor_;
    protected double rhoBorder_;
    protected double rhoBorder2_;
    protected int leftCenterX_;
    protected int rightCenterX_;
    protected double leftLambdaC_;
    protected double leftPhiC_;
    protected double rightLambdaC_;
    protected double rightPhiC_;
    protected double leftLambdaCRad_;
    protected double leftPhiCRad_;
    protected double rightLambdaCRad_;
    protected double rightPhiCRad_;
    protected double sinLeftPhiC_;
    protected double cosLeftPhiC_;
    protected double sinRightPhiC_;
    protected double cosRightPhiC_;
    protected ProjDoubleParameter rotateParam_;
    protected double thirdRotation_;
    protected LonLatRotator leftRotMatrices_;
    protected LonLatRotator rightRotMatrices_;

    public TwoHemisphereAzimuthalProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double rMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, 2.04 * rMaxOverR, rMaxOverR);
        this.radiusFactor_ = rMaxOverR;
        this.leftRotMatrices_ = new LonLatRotator(0.0, 0.0);
        this.rightRotMatrices_ = new LonLatRotator(0.0, 0.0);
        this.setCenter(this.lambdaC_, this.phiC_);
        this.rotateParam_ = new ProjDoubleParameter("Third rotation", "Third rotation", "\u00b0", this.thirdRotation_, -360.0, 360.0, true, true);
        this.addParameter(this.rotateParam_);
        this.autoscale();
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.radiusFactor_ * this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.outWidth_ - ins.right));
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.leftLambdaC_ = lon;
        this.leftPhiC_ = lat;
        this.rightLambdaC_ = lon + 180.0;
        this.rightPhiC_ = -lat;
        this.leftLambdaCRad_ = Math.toRadians(this.leftLambdaC_);
        this.leftPhiCRad_ = Math.toRadians(this.leftPhiC_);
        this.rightLambdaCRad_ = Math.toRadians(this.rightLambdaC_);
        this.rightPhiCRad_ = Math.toRadians(this.rightPhiC_);
        this.sinLeftPhiC_ = Math.sin(this.leftPhiCRad_);
        this.cosLeftPhiC_ = Math.cos(this.leftPhiCRad_);
        this.sinRightPhiC_ = Math.sin(this.rightPhiCRad_);
        this.cosRightPhiC_ = Math.cos(this.rightPhiCRad_);
        this.setXRotation(this.thirdRotation_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        super.parameterChanged(e);
        this.setXRotation(this.rotateParam_.getValue());
    }

    public void setXRotation(double angle) {
        this.thirdRotation_ = angle;
        if (this.leftRotMatrices_ != null) {
            this.leftRotMatrices_.setAngles(this.leftLambdaC_, this.leftPhiC_, this.thirdRotation_);
            this.rightRotMatrices_.setAngles(this.rightLambdaC_, this.rightPhiC_, -this.thirdRotation_);
        }
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double leftLambdaRad = Math.toRadians(lon - this.leftLambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosZ = this.sinLeftPhiC_ * Math.sin(phiRad) + this.cosLeftPhiC_ * Math.cos(phiRad) * Math.cos(leftLambdaRad);
        boolean leftside = cosZ >= 0.0;
        double[] llP = leftside ? this.leftRotMatrices_.rotate(lon, lat) : this.rightRotMatrices_.rotate(lon, lat);
        double lambdaPRad = Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double sinPhiP = Math.sin(phiPRad);
        double k = this.getKForLambdaPPhiP(lambdaPRad, phiPRad);
        double x = k > 0.0 ? k * cosPhiP * Math.sin(lambdaPRad) : 0.0;
        double y = k > 0.0 ? k * sinPhiP : 0.0;
        x = leftside ? (double)this.leftCenterX_ + x * this.rS_ : (double)this.rightCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    protected abstract double getKForLambdaPPhiP(double var1, double var3);

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            if (leftside) {
                return this.getCenter();
            }
            return new PointLL(this.rightLambdaC_, this.rightPhiC_);
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = this.getZForRhoRS(rho);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double lambdaPRad = Math.atan2(x * sinZ, rho * cosZ);
        double phiPRad = Math.asin(y * sinZ / rho);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = leftside ? this.leftRotMatrices_.inverse(lambdaP, phiP) : this.rightRotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TwoHemisphereAzimuthalProjection twoHemisphereAzimuthalProjection = this;
        synchronized (twoHemisphereAzimuthalProjection) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > this.rhoBorder2_) continue;
                    double rho = Math.sqrt(rho2);
                    double z = this.getZForRhoRS(rho);
                    double sinZ = Math.sin(z);
                    double cosZ = Math.cos(z);
                    double phiPRad = Math.asin(y * sinZ / rho);
                    double lambdaPRad = Math.atan2(x * sinZ, rho * cosZ);
                    double phiP = Math.toDegrees(phiPRad);
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    this.setEightPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    protected abstract double getZForRhoRS(double var1);

    protected void setEightPoints(int ix, int iy, double lambdaP, double phiP) {
        double[] llTR = this.leftRotMatrices_.inverse(lambdaP, phiP);
        double[] llBR = this.leftRotMatrices_.inverse(lambdaP, -phiP);
        double[] llBL = this.leftRotMatrices_.inverse(-lambdaP, -phiP);
        double[] llTL = this.leftRotMatrices_.inverse(-lambdaP, phiP);
        this.setPoint(true, ix, iy, llTR[0], llTR[1]);
        this.setPoint(true, ix, -iy - 1, llBR[0], llBR[1]);
        this.setPoint(true, -ix - 1, -iy - 1, llBL[0], llBL[1]);
        this.setPoint(true, -ix - 1, iy, llTL[0], llTL[1]);
        llTR = this.rightRotMatrices_.inverse(lambdaP, phiP);
        llBR = this.rightRotMatrices_.inverse(lambdaP, -phiP);
        llBL = this.rightRotMatrices_.inverse(-lambdaP, -phiP);
        llTL = this.rightRotMatrices_.inverse(-lambdaP, phiP);
        this.setPoint(false, ix, iy, llTR[0], llTR[1]);
        this.setPoint(false, ix, -iy - 1, llBR[0], llBR[1]);
        this.setPoint(false, -ix - 1, -iy - 1, llBL[0], llBL[1]);
        this.setPoint(false, -ix - 1, iy, llTL[0], llTL[1]);
    }

    private void setPoint(boolean leftside, int ix, int iy, double dlambda, double phi) {
        int srcX;
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_) {
            return;
        }
        double lon = dlambda;
        int index = row * this.outWidth_ + col;
        this.invArrayLon_[index] = MapUtils.normalize360(lon);
        this.invArrayLat_[index] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1 && (srcX = this.getSrcPixelX(lon)) > -1) {
            this.invArray_[index] = srcY * this.srcWidth_ + srcX;
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjectionUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
        ProjectionUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            Point2D.Double dot;
            if (lat == 0.0) {
                return;
            }
            if (lat < 0.0) {
                return;
            }
            Point2D.Double double_ = dot = this.phiC_ > 90.0 ? this.transformLL2XYIgnoreMargins(this.lambdaC_, Math.abs(lat)) : this.transformLL2XYIgnoreMargins(this.lambdaC_, -Math.abs(lat));
            if (dot == null) {
                return;
            }
            double r = Math.abs((double)this.outCenterY_ - dot.y);
            ProjectionUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, r, r);
            ProjectionUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, r, r);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        if (this.phiC_ == 90.0 || this.phiC_ == -90.0) {
            Point2D.Double dot = this.phiC_ > 0.0 ? this.transformLL2XYIgnoreMargins(lon, 1.0E-5) : this.transformLL2XYIgnoreMargins(lon, -1.0E-5);
            GraphicUtils.drawLine(g2d, this.leftCenterX_, this.outCenterY_, dot.x, dot.y);
            dot = this.phiC_ > 0.0 ? this.transformLL2XYIgnoreMargins(lon, -1.0E-5) : this.transformLL2XYIgnoreMargins(lon, 1.0E-5);
            GraphicUtils.drawLine(g2d, this.rightCenterX_, this.outCenterY_, dot.x, dot.y);
        } else {
            super.drawMeridian(g2d, lon, label);
        }
    }
}

