/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class PutninsP4p
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Putni\u0146\u0161 P4'";
    private static final double CONST_A = 2.0 * Math.sqrt(0.1909859317102744);
    private static final double CONST_B = 2.0 * Math.sqrt(3.7699111843077517);
    private static final double CONST_C = 0.8838834764831844;
    private static final double INV_C = 1.131370849898476;
    private static final double WIDTH_FACTOR = CONST_A * Math.PI;
    private static final double HEIGHT_FACTOR = CONST_B * Math.sin(Math.asin(0.8838834764831844) / 3.0);
    private double invRSA_;
    private double invRSB_;

    public PutninsP4p(int width, int height) {
        this(width, height, 0, 0);
    }

    public PutninsP4p(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public PutninsP4p(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.invRSA_ = this.invRS_ / CONST_A;
        this.invRSB_ = this.invRS_ / CONST_B;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double psiRad = Math.asin(0.8838834764831844 * Math.sin(phiRad));
        double x = CONST_A * this.lonToLambdaRad(lon) * Math.cos(psiRad) / Math.cos(psiRad / 3.0);
        double y = CONST_B * Math.sin(psiRad / 3.0);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = 3.0 * Math.asin(y * this.invRSB_);
        double phiRad = Math.asin(Math.sin(psiRad) * 1.131370849898476);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * this.invRSA_ * (Math.cos(psiRad / 3.0) / Math.cos(psiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        PutninsP4p putninsP4p = this;
        synchronized (putninsP4p) {
            double y;
            double psiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(Math.sin(psiRad = 3.0 * Math.asin((y = (double)iy + 0.5) * this.invRSB_)) * 1.131370849898476)) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRSA_ * (Math.cos(psiRad / 3.0) / Math.cos(psiRad));
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lambdaRad = x * xFactor;
                    if (lambdaRad > Math.PI) continue;
                    this.set4SymmetricPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

