/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.text.StringUtils;
import java.util.Objects;

public class ProjDoubleParameter
extends ProjExtraParameter {
    private double value_;
    private double defaultValue_;
    private double min_;
    private double max_;
    private boolean minAllowed_ = true;
    private boolean maxAllowed_ = true;

    public ProjDoubleParameter(String description, String label, String units, double value) {
        this(description, label, units, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true, true);
    }

    public ProjDoubleParameter(String description, String label, String units, double value, double min, double max) {
        this(description, label, units, value, min, max, true, true);
    }

    public ProjDoubleParameter(String description, String label, String units, double value, double min, double max, boolean minAllowed, boolean maxAllowed) {
        super(description, label, units);
        this.min_ = min;
        this.max_ = max;
        this.minAllowed_ = minAllowed;
        this.maxAllowed_ = maxAllowed;
        this.defaultValue_ = value;
        this.setValue(this.defaultValue_);
    }

    @Override
    public void reset() {
        this.setValue(this.defaultValue_);
    }

    public double getDefault() {
        return this.defaultValue_;
    }

    public double getValue() {
        return this.value_;
    }

    public double getMinimum() {
        return this.min_;
    }

    public double getMaximum() {
        return this.max_;
    }

    public boolean isMinimumInclusive() {
        return this.minAllowed_;
    }

    public boolean isMaximumInclusive() {
        return this.maxAllowed_;
    }

    @Override
    public Object getDefaultObject() {
        return this.defaultValue_;
    }

    @Override
    public Object getValueObject() {
        return this.value_;
    }

    @Override
    public void setValue(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value musy not be null.");
        if (value instanceof Double) {
            this.setValue((Double)value);
        } else if (value instanceof Number) {
            this.setValue((Double)value);
        } else if (value instanceof String) {
            this.setValue((String)value);
        } else {
            throw new IllegalArgumentException("Value does not appear to be a Double");
        }
    }

    @Override
    public void setValue(String value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        try {
            this.setValue(StringUtils.parseDouble(value));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a Double: " + value);
        }
    }

    public final void setValue(double value) throws IllegalArgumentException {
        if (value == this.value_) {
            return;
        }
        if (value < this.min_) {
            throw new IllegalArgumentException("Value less than minimum: " + value + " < " + this.min_);
        }
        if (value <= this.min_ && !this.minAllowed_) {
            throw new IllegalArgumentException("Value must be greater than minimum: " + value + " \u2264 " + this.min_);
        }
        if (value > this.max_) {
            throw new IllegalArgumentException("Value greater than maximum: " + value + " > " + this.max_);
        }
        if (value >= this.max_ && !this.maxAllowed_) {
            throw new IllegalArgumentException("Value must be less than maximum: " + value + " \u2265 " + this.max_);
        }
        this.value_ = value;
        this.fireChange();
    }
}

