/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjExtraParameter;
import java.util.Objects;

public class ProjBooleanParameter
extends ProjExtraParameter {
    private final boolean defaultValue_;
    private boolean value_;

    public ProjBooleanParameter(String descriotion, String label, boolean value) {
        super(descriotion, label, null);
        this.defaultValue_ = value;
        this.setValue(this.defaultValue_);
    }

    @Override
    public void reset() {
        this.setSelected(this.defaultValue_);
    }

    public boolean getDefault() {
        return this.defaultValue_;
    }

    @Override
    public Object getDefaultObject() {
        return this.defaultValue_;
    }

    public boolean isSelected() {
        return this.value_;
    }

    @Override
    public Object getValueObject() {
        return this.value_;
    }

    @Override
    public final void setValue(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Value is not a Boolean.");
        }
        this.setSelected((Boolean)value);
    }

    @Override
    public final void setValue(String value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        try {
            boolean b = Boolean.parseBoolean(value);
            this.setSelected(b);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not a boolean: " + value);
        }
    }

    public void setSelected(boolean value) {
        if (value == this.value_) {
            return;
        }
        this.value_ = value;
        this.fireChange();
    }
}

