/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class McBrydeS3
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "McBryde S3";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 55.85;
    private static final double JOIN_LAT_RAD = Math.toRadians(55.85);
    private static final double YSHIFT = 0.069065;
    private static final double CONST_C = Math.sqrt(0.840148730267336);
    private static final double CONST_D = 1.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = CONST_C * 1.5707963267948966 - 0.069065;
    private double joinYRS_;
    private double threeOver2RSC_;

    public McBrydeS3(int width, int height) {
        this(width, height, 0, 0);
    }

    public McBrydeS3(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public McBrydeS3(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, Math.PI, HEIGHT_FACTOR);
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.CONTINENTS_MCBRYDE.toString());
        interrupt.setValue(Interruption.CONTINENTS_MCBRYDE.toString());
        this.parameterChanged(null);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        this.threeOver2RSC_ = 1.5 * this.invRS_ / CONST_C;
        double yy = JOIN_LAT_RAD;
        this.joinYRS_ = yy * this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double y;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double thetaRad = 0.0;
        if (absLat > 55.85) {
            double phiFactor = 1.7853981633974483 * Math.sin(phiRad);
            thetaRad = Math.toRadians(lat);
            for (int iter = 0; iter < 33; ++iter) {
                double func = 0.5 * thetaRad + Math.sin(thetaRad) - phiFactor;
                double dfunc = 0.5 + Math.cos(thetaRad);
                double dthetaRad = -func / dfunc;
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            y = CONST_C * thetaRad;
            y = lat > 0.0 ? (y -= 0.069065) : (y += 0.069065);
        } else {
            y = phiRad;
        }
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon);
            dx = absLat > 55.85 ? (dx *= CONST_C * (0.5 + Math.cos(thetaRad)) / 1.5) : (dx *= Math.cos(phiRad));
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            x = absLat > 55.85 ? (x *= CONST_C * (0.5 + Math.cos(thetaRad)) / 1.5) : (x *= Math.cos(phiRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double xFactor;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.joinYRS_) {
            double sinTheta;
            double yOverRS = Math.abs(y) * this.invRS_ + 0.069065;
            double thetaRad = yOverRS / CONST_C;
            phiRad = Math.asin((0.5 * thetaRad + (sinTheta = Math.sin(thetaRad))) / 1.7853981633974483);
            if (phiRad > 1.5707963267948966) {
                return null;
            }
            if (y < 0.0) {
                phiRad = 0.0 - phiRad;
            }
            xFactor = this.threeOver2RSC_ / (0.5 + Math.cos(thetaRad));
        } else {
            phiRad = y * this.invRS_;
            xFactor = this.invRS_ / Math.cos(phiRad);
        }
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        McBrydeS3 mcBrydeS3 = this;
        synchronized (mcBrydeS3) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double xFactor;
                double phiRad;
                double y = (double)iy + 0.5;
                if (Math.abs(y) > this.joinYRS_) {
                    double yOverRS = y * this.invRS_;
                    yOverRS = y > 0.0 ? (yOverRS += 0.069065) : (yOverRS -= 0.069065);
                    double thetaRad = yOverRS / CONST_C;
                    double sinTheta = Math.sin(thetaRad);
                    phiRad = Math.asin((0.5 * thetaRad + sinTheta) / 1.7853981633974483);
                    if (phiRad > 1.5707963267948966) break;
                    xFactor = this.threeOver2RSC_ / (0.5 + Math.cos(thetaRad));
                } else {
                    phiRad = y * this.invRS_;
                    xFactor = this.invRS_ / Math.cos(phiRad);
                }
                double phi = Math.toDegrees(phiRad);
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setPoint(ix, iy, lon, phi);
                }
            }
        }
    }
}

