/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Dimension;

public class LogarithmicAzimuthal
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Logarithmic Azimuthal";
    private static final double MAX_RADIUS = 150.0;
    private static final double DEFAULT_RADIUS = 90.0;
    private double centralScaling_ = 5.0;
    private double logSBFactor_;
    private double invLogSBFactor_;
    private ProjDoubleParameter centParam_;

    public LogarithmicAzimuthal(int width, int height) {
        this(width, height, 0, 0);
    }

    public LogarithmicAzimuthal(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public LogarithmicAzimuthal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addEdgeRadiusParameter(90.0, 150.0, false);
        this.centParam_ = new ProjDoubleParameter("Central scaling factor", "Central Scaling", "", 30.0, 0.0, 500.0, false, true);
        this.addParameter(this.centParam_);
        this.addFillParameter();
        this.parameterChanged(null);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.centParam_) {
            this.setCentralScaling(this.centParam_.getValue());
        }
    }

    @Override
    public void setEdgeRadius(double r) {
        this.radiusDeg_ = r;
        this.radiusRad_ = Math.toRadians(this.radiusDeg_);
        this.logSBFactor_ = Math.log(1.0 + this.centralScaling_ * this.radiusRad_);
        this.invLogSBFactor_ = 1.0 / this.logSBFactor_;
        this.autoscale();
    }

    public void setCentralScaling(double csf) {
        this.centralScaling_ = csf;
        this.logSBFactor_ = Math.log(1.0 + this.centralScaling_ * this.radiusRad_);
        this.invLogSBFactor_ = 1.0 / this.logSBFactor_;
        this.autoscale();
    }

    @Override
    protected void prepareScaling() {
        double lz = Math.log(1.0 + this.centralScaling_ * this.radiusRad_) * this.invLogSBFactor_;
        this.setSizeFactor(lz);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double rhoBOverR = Math.log(1.0 + this.centralScaling_ * Math.toRadians(150.0)) * this.invLogSBFactor_;
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double rho = Math.log(1.0 + this.centralScaling_ * z) * this.invLogSBFactor_;
        if (rho < 0.0) {
            return -1.0;
        }
        return rho / Math.sin(z);
    }

    @Override
    protected double getZForRhoRS(double rhoRS) {
        double rho = rhoRS * this.invRS_;
        if (this.centralScaling_ > 0.0) {
            return (Math.exp(rho * this.logSBFactor_) - 1.0) / this.centralScaling_;
        }
        return rho;
    }
}

