/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.TwoHemisphereGlobularProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Fournier1TwoH
extends TwoHemisphereGlobularProjection {
    public static final String PROJECTION_NAME = "Fournier Globular I (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000020;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public Fournier1TwoH(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fournier1TwoH(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Fournier1TwoH(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000020, width, height, xmargin, ymargin, 1.5707963267948966);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (lat == 0.0) {
            x = lambdaRad;
        } else if (absLambdaRad < 1.0E-5) {
            y = phiRad;
        } else if (absLambdaRad > 1.5707863267948965) {
            x = lambdaRad * Math.cos(phiRad);
            y = 1.5707963267948966 * Math.sin(phiRad);
        } else {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double fourLambdaRad2 = 4.0 * lambdaRad2;
            double phiRad2 = phiRad * phiRad;
            double sinPhi = Math.sin(absPhiRad);
            double valC = 2.4674011002723395;
            double valP = Math.PI * sinPhi;
            double valS = (2.4674011002723395 - phiRad2) / (valP - 2.0 * absPhiRad);
            double valR = valS - absPhiRad;
            double sqTerm = fourLambdaRad2 * lambdaRad2 + Math.PI * 2 * lambdaRad2 * (2.0 * valS * sinPhi - Math.PI) + Math.PI * Math.PI * valR * valR;
            double cosT = (Math.PI * Math.sqrt(sqTerm) - fourLambdaRad2 * valS) / (valR * (Math.PI * Math.PI - fourLambdaRad2));
            y = valS - valR * cosT;
            x = lambdaRad * Math.sqrt(1.0 - y * y / 2.4674011002723395);
            if (phiRad < 0.0) {
                y = -y;
            }
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double fguess;
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double absXOverRS = Math.abs(xOverRS);
        double absYOverRS = Math.abs(yOverRS);
        if (absXOverRS > 1.5707963267948966 || absYOverRS > 1.5707963267948966) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return leftside ? new PointLL(this.lambdaC_, 0.0) : new PointLL(this.lambdaC_ + 180.0, 0.0);
        }
        double xOverRs = x * this.invRS_;
        double yOverRs = y * this.invRS_;
        double lambdaRad = xOverRs / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395);
        if (lambdaRad > 1.5707963267948966) {
            return null;
        }
        if (y == 0.0) {
            return new PointLL(this.lambdaC_ + lambdaRad, 0.0);
        }
        double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
        double phiRad = fguess = Math.abs(lambdaRad) < 0.5183627878423159 ? yOverRs : Math.asin(yOverRs / Math.sqrt(x2PlusY2));
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double piSinPhi = Math.PI * sinPhi;
            double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
            double r = s - phiRad;
            double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
            double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
            double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (!leftside) {
            lambdaRad += Math.PI;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Fournier1TwoH fournier1TwoH = this;
        synchronized (fournier1TwoH) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRs;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRs = y * this.invRS_;
                double phiRad = y / (double)this.dyMax_ * 1.5707963267948966;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRs = (x = (double)ix + 0.5) * this.invRS_) / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395)) > 1.5707963267948966); ++ix) {
                    double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
                    for (int iter = 0; iter < 33; ++iter) {
                        double cosPhi = Math.cos(phiRad);
                        double sinPhi = Math.sin(phiRad);
                        double piSinPhi = Math.PI * sinPhi;
                        double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
                        double r = s - phiRad;
                        double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
                        double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
                        double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
                        double dphiRad = -func / dfunc;
                        phiRad += dphiRad;
                        if (Math.abs(dphiRad) < 1.0E-5) break;
                    }
                    double lambdaP = Math.toDegrees(lambdaRad);
                    double phiP = Math.toDegrees(phiRad);
                    this.setEightPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            double outCenterHX = i == 0 ? (double)this.leftCenterX_ : (double)this.rightCenterX_;
            Point2D.Double cent = this.transformLL2XY(lambdaCH, lat);
            Point2D.Double east = this.transformLL2XY(lambdaCH + 89.99999, lat);
            Point2D.Double west = this.transformLL2XY(lambdaCH + -89.99999, lat);
            if (lat == 0.0) {
                GraphicUtils.drawLine(g2d, west.x, this.outCenterY_, east.x, this.outCenterY_);
                continue;
            }
            double px = 0.5 * (cent.x + east.x);
            double py = 0.5 * (cent.y + east.y);
            double s1 = (east.y - cent.y) / (east.x - cent.x);
            double s2 = 1.0 / s1;
            double cx = outCenterHX;
            double cy = py - s2 * (cx - px);
            double dx = east.x - cx;
            double dy = east.y - cy;
            double d = Math.hypot(dx, dy);
            double aa = Math.toDegrees(Math.acos(dx / d));
            double ee = 2.0 * (90.0 - aa);
            Arc2D.Double arc = new Arc2D.Double();
            arc.setArcByCenter(cx, cy, d, aa + 180.0, ee, 0);
            g2d.draw(arc);
            arc.setArcByCenter(cx, 2.0 * (double)this.outCenterY_ - cy, d, aa, ee, 0);
            g2d.draw(arc);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        double lambda = this.lonToLambda(lon);
        if (Math.abs(lambda) == 90.0) {
            return;
        }
        Point2D.Double cent = this.transformLL2XY(lon, 0.0);
        if (cent == null) {
            return;
        }
        double lambdaRad = Math.toRadians(lambda);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double yn = (double)this.outCenterY_ - 1.5707963267948966 * this.rS_;
        double ys = (double)this.outCenterY_ + 1.5707963267948966 * this.rS_;
        double centerX = rightside ? (double)this.rightCenterX_ : (double)this.leftCenterX_;
        double w = cent.x - centerX;
        double h = ys - yn;
        if (w == 0.0) {
            GraphicUtils.drawLine(g2d, centerX, yn, centerX, ys);
        } else if (w > 0.0) {
            Arc2D.Double arc = new Arc2D.Double(centerX - w, yn, 2.0 * w, h, -90.0, 180.0, 0);
            g2d.draw(arc);
        } else {
            Arc2D.Double arc = new Arc2D.Double(cent.x, yn, -2.0 * w, h, 90.0, 180.0, 0);
            g2d.draw(arc);
        }
    }
}

