/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class EquirectangularRegional
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Equirectangular Regional";
    public static final int PROPERTIES = 0x200004;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private double xPxlPerDeg_ = 1.0;
    private double yPxlPerDeg_ = 1.0;
    private double xDegPerPxl_ = 1.0;
    private double yDegPerPxl_ = 1.0;
    private double widthDeg_ = 1.0;
    private double heightDeg_ = 1.0;
    private float lMargin_;
    private float rMargin_;
    private float tMargin_;
    private float bMargin_;
    private Path2D.Double path_;
    private ProjDoubleParameter hghtParam_ = new ProjDoubleParameter("Angular distance between top and bottom center of map", "Height", "\u00b0", 45.0, 0.002, 180.0, true, true);
    private ProjDoubleParameter wdthParam_ = new ProjDoubleParameter("Distance between left and right sides of map", "Width", "\u00b0", 90.0, 0.002, 360.0, true, true);

    public EquirectangularRegional(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public EquirectangularRegional(int width, int height) {
        this(width, height, 0, 0);
    }

    public EquirectangularRegional(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200004, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.wdthParam_);
        this.addParameter(this.hghtParam_);
        this.parameterChanged(null);
        this.path_ = new Path2D.Double();
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        this.widthDeg_ = this.wdthParam_.getValue();
        this.heightDeg_ = this.hghtParam_.getValue();
        this.autoscale();
    }

    public double getWidth() {
        return this.widthDeg_;
    }

    public void setWidth(double w) {
        this.widthDeg_ = w;
        this.autoscale();
    }

    public double getHeight() {
        return this.heightDeg_;
    }

    public void setHeight(double h) {
        this.heightDeg_ = h;
        this.autoscale();
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    protected final void finishScaling() {
        Insets ins = this.getInsets();
        this.xPxlPerDeg_ = (double)(this.outWidth_ - 2 * ins.left) / this.widthDeg_;
        this.yPxlPerDeg_ = (double)(this.outHeight_ - 2 * ins.top) / this.heightDeg_;
        this.xDegPerPxl_ = 1.0 / this.xPxlPerDeg_;
        this.yDegPerPxl_ = 1.0 / this.yPxlPerDeg_;
        this.lMargin_ = ins.left;
        this.rMargin_ = this.outWidth_ - ins.right;
        this.tMargin_ = ins.top;
        this.bMargin_ = this.outHeight_ - ins.bottom;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double x = MapUtils.normalizeMP180(lon - this.lambdaC_) * this.xPxlPerDeg_;
        double y = -(lat - this.phiC_) * this.yPxlPerDeg_;
        return new Point2D.Double(x += (double)this.outCenterX_, y += (double)this.outCenterY_);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phi = this.phiC_ + y * this.yDegPerPxl_;
        if (Math.abs(phi) > 90.0) {
            return null;
        }
        double lambda = x * this.xDegPerPxl_;
        if (Math.abs(lambda) > 180.0) {
            return null;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        EquirectangularRegional equirectangularRegional = this;
        synchronized (equirectangularRegional) {
            double copLat = this.phiC_;
            Insets ins = this.getInsets();
            int maxdx = (this.outWidth_ - 2 * ins.left) / 2;
            int maxdy = (this.outHeight_ - 2 * ins.top) / 2;
            for (int iy = -maxdy; iy < maxdy; ++iy) {
                double x;
                double lambda;
                double y = (double)iy + 0.5;
                double phi = copLat + y * this.yDegPerPxl_;
                if (phi < -90.0) continue;
                if (phi > 90.0) break;
                for (int ix = 0; ix < maxdx && !((lambda = (x = (double)ix + 0.5) * this.xDegPerPxl_) > 180.0); ++ix) {
                    this.set2SymmetricPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    protected void set2SymmetricPoints(int ix, int iy, double lambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        if (row < 0 || row >= this.outHeight_ || col < 0 || col >= this.outWidth_ || colF < 0 || colF >= this.outWidth_) {
            return;
        }
        int indexR = row * this.outWidth_ + col;
        int indexL = row * this.outWidth_ + colF;
        this.invArrayLon_[indexR] = MapUtils.normalize360(this.lambdaC_ + lambda);
        this.invArrayLon_[indexL] = MapUtils.normalize360(this.lambdaC_ - lambda);
        this.invArrayLat_[indexR] = phi;
        this.invArrayLat_[indexL] = phi;
        int srcY = this.getSrcPixelY(phi);
        if (srcY > -1) {
            int srcXF;
            int srcX = this.getSrcPixelX(this.lambdaC_ + lambda);
            if (srcX > -1) {
                this.invArray_[indexR] = srcY * this.srcWidth_ + srcX;
            }
            if ((srcXF = this.getSrcPixelX(this.lambdaC_ - lambda)) > -1) {
                this.invArray_[indexL] = srcY * this.srcWidth_ + srcXF;
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Stroke oldstroke = g2d.getStroke();
        g2d.setStroke(ProjectionUtils.getSquareMiterStroke(oldstroke));
        Point2D.Double np = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double sp = this.transformLL2XY(this.lambdaC_, -90.0);
        float top = np == null || np.y < (double)this.tMargin_ ? this.tMargin_ : (float)np.y;
        float bottom = sp == null || sp.y > (double)this.bMargin_ ? this.bMargin_ : (float)sp.y;
        this.path_.reset();
        this.path_.moveTo(this.lMargin_, top);
        this.path_.lineTo(this.lMargin_, bottom);
        this.path_.lineTo(this.rMargin_, bottom);
        this.path_.lineTo(this.rMargin_, top);
        this.path_.closePath();
        g2d.draw(this.path_);
        g2d.setStroke(oldstroke);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_, lat);
        if (dot == null) {
            return;
        }
        if (dot.y <= (double)this.tMargin_ + 0.5) {
            return;
        }
        if (dot.y >= (double)this.bMargin_ - 0.5) {
            return;
        }
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = this.rMargin_ - (float)fh2 - (float)w;
            g2d.drawString(label, labelx, (float)(dot.y + (double)fh2 - (double)(des / 2)));
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot.y - (double)fh2, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, this.lMargin_, dot.y, this.rMargin_, dot.y);
        g2d.setClip(oldclip);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, String label) {
        Point2D.Double dot = this.transformLL2XY(lon, this.phiC_);
        if (dot == null) {
            return;
        }
        if (dot.x <= (double)this.lMargin_ + 0.5) {
            return;
        }
        if (dot.x >= (double)this.rMargin_ - 0.5) {
            return;
        }
        Point2D.Double np = this.transformLL2XY(this.lambdaC_, 90.0);
        Point2D.Double sp = this.transformLL2XY(this.lambdaC_, -90.0);
        float top = np == null || np.y < (double)this.tMargin_ ? this.tMargin_ : (float)np.y;
        float bottom = sp == null || sp.y > (double)this.bMargin_ ? this.bMargin_ : (float)sp.y;
        Shape oldclip = g2d.getClip();
        if (label != null) {
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            int des = fm.getDescent();
            int fh = fm.getHeight();
            int fh2 = fh / 2;
            int fh4 = fh / 4;
            float labelx = (float)(dot.x - 0.5 * (double)w);
            g2d.drawString(label, labelx, bottom - (float)fh2 - (float)des);
            Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, bottom - (float)fh2 - (float)fh, w + fh2, fh);
            Area clipArea = new Area(oldclip);
            Area textArea = new Area(textRect);
            clipArea.subtract(textArea);
            g2d.setClip(clipArea);
        }
        GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
        g2d.setClip(oldclip);
    }

    @Override
    public LonLatBounds getBounds() {
        double llLeft = this.lambdaC_ - 0.5 * this.widthDeg_;
        double llRight = this.lambdaC_ + 0.5 * this.widthDeg_;
        double llTop = this.phiC_ + 0.5 * this.heightDeg_;
        double llBottom = this.phiC_ - 0.5 * this.heightDeg_;
        return new LonLatBounds(llLeft, llTop, llRight, llBottom);
    }
}

