/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class Baranyi4
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Baranyi IV";
    private static final double F1 = 0.11679;
    private static final double F2 = 0.31255;
    private static final double A1A = 1.22172;
    private static final double A1B = 2.115292;
    private static final double A2A = 38.4304449;
    private static final double A2B = 4.5848;
    private static final double B1 = 1.0;
    private static final double B3 = 0.112579;
    private static final double B4 = -0.107505;
    private static final double B5 = 0.0273759;
    private static final double CONST_Y0 = 1.22172 + Math.sqrt(2.115292);
    private static final double WIDTH_FACTOR = Baranyi4.getFForLambda(Math.PI) * CONST_Y0;
    private static final double HEIGHT_FACTOR = Baranyi4.getYForLat(90.0);
    private static final double JOIN_Y = 1.40538824071;

    public Baranyi4(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi4(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public Baranyi4(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, WIDTH_FACTOR, HEIGHT_FACTOR);
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double y = Baranyi4.getYForLat(lat);
        double yterm = Baranyi4.getYTerm(y);
        double lambdaRad = this.lonToLambdaRad(lon);
        double f = Baranyi4.getFForLambda(lambdaRad);
        double x = f * yterm;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double yterm;
        double xOverRS;
        double f;
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x) * this.invRS_;
        double absy = Math.abs(y) * this.invRS_;
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = this.iterateYOverRSToPhiRad(Math.abs(yOverRS));
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        if ((lambdaRad = (Math.exp(0.31255 * (f = Math.abs((xOverRS = x * this.invRS_) / (yterm = Baranyi4.getYTerm(yOverRS))))) - 1.0) / 0.11679) > Math.PI) {
            return null;
        }
        if (x < 0.0) {
            lambdaRad = -lambdaRad;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi4 baranyi4 = this;
        synchronized (baranyi4) {
            double y;
            double yOverRS;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = this.iterateYOverRSToPhiRad(Math.abs(yOverRS = (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double x;
                double xOverRS;
                double f;
                double lambdaRad;
                if (y < 0.0) {
                    phiRad = -phiRad;
                }
                double yterm = Baranyi4.getYTerm(yOverRS);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (Math.exp(0.31255 * (f = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) / yterm)) - 1.0) / 0.11679) > Math.PI); ++ix) {
                    double phi = Math.toDegrees(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    this.set4SymmetricPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private static double getYForLat(double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double absPhiRad2 = absPhiRad * absPhiRad;
        double y = absPhiRad * (1.0 + absPhiRad2 * (0.112579 + absPhiRad * (-0.107505 + 0.0273759 * absPhiRad)));
        if (lat < 0.0) {
            y = -y;
        }
        return y;
    }

    private static double getYTerm(double y) {
        double y2 = y * y;
        if (y2 < 1.0E-5) {
            return CONST_Y0;
        }
        if (Math.abs(y) < 1.40538824071) {
            return 1.22172 + Math.sqrt(2.115292 - y2);
        }
        double sqt = 4.5848 + Math.abs(y);
        return Math.sqrt(Math.abs(38.4304449 - sqt * sqt));
    }

    private static double getFForLambda(double lambdaRad) {
        double f = Math.log(1.0 + 0.11679 * Math.abs(lambdaRad)) / 0.31255;
        if (lambdaRad < 0.0) {
            return -f;
        }
        return f;
    }

    private double iterateYOverRSToPhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * (yOverRS / HEIGHT_FACTOR);
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = phiRad * (1.0 + phiRad2 * (0.112579 + phiRad * (-0.107505 + 0.0273759 * phiRad))) - yOverRS;
            double dfunc = 1.0 + phiRad * (0.337737 + phiRad * (-0.43002 + 0.13687950000000002 * phiRad));
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

