/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.map.proj.Interruption;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.math.PointLL;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class BakerDinomic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Baker Dinomic";
    public static final int PROPERTIES = 0x100000A;
    private static final double JOIN_LAT = 45.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 2.221441469079183;
    private double joinYRS_;

    public BakerDinomic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BakerDinomic(Dimension size, Dimension margin) {
        this(size.width, size.height, margin.width, margin.height);
    }

    public BakerDinomic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x100000A, width, height, xmargin, ymargin, Math.PI, 2.221441469079183);
        this.cylindricLatLimit_ = 45.0;
        ProjListParameter interrupt = (ProjListParameter)this.getParameter(0);
        interrupt.setDefault(Interruption.CONTINENTS_BAKER.toString());
        interrupt.setValue(Interruption.CONTINENTS_BAKER.toString());
        this.parameterChanged(null);
        this.finishScaling();
    }

    @Override
    protected final void finishScaling() {
        double yy = Math.log(Math.tan(1.1780972450961724));
        this.joinYRS_ = yy * this.rS_;
    }

    @Override
    public Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        double absLat = Math.abs(lat);
        if (absLat > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90,90]&#176;.");
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double y = 0.0;
        y = absPhiRad < 1.0E-5 ? 0.0 : (absPhiRad <= 0.7853981633974483 ? Math.log(Math.tan(0.5 * absPhiRad + 0.7853981633974483)) : Math.log(1.0 / Math.tan(0.5 * absPhiRad)) + 2.8284271247461903 * (absPhiRad - 0.7853981633974483));
        if (phiRad < 0.0) {
            y = -y;
        }
        if (this.isShowingInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double clon = gore[1];
            double dlon = MapUtils.normalizeMP180(lon) - clon;
            if (MapUtils.normalizeMP180(lon) > gore[2]) {
                dlon -= 360.0;
            }
            double dx = Math.toRadians(dlon);
            if (absLat > 45.0) {
                dx *= Math.cos(absPhiRad) * (2.8284271247461903 - 1.0 / Math.sin(absPhiRad));
            }
            double cx = this.lonToLambdaRad(clon);
            x = cx + dx;
        } else {
            x = this.lonToLambdaRad(lon);
            if (absLat > 45.0) {
                x *= Math.cos(absPhiRad) * (2.8284271247461903 - 1.0 / Math.sin(absPhiRad));
            }
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double absY = Math.abs(y);
        double xOverRS = x * this.invRS_;
        double yOverRS = absY * this.invRS_;
        double lambdaRad = 0.0;
        double phiRad = 0.0;
        if (absY <= this.joinYRS_) {
            phiRad = 2.0 * Math.atan(Math.exp(yOverRS)) - 1.5707963267948966;
            lambdaRad = xOverRS;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
            if (y < 0.0) {
                phiRad = -phiRad;
            }
            double lambda = Math.toDegrees(lambdaRad);
            double phi = Math.toDegrees(phiRad);
            return new PointLL(this.lambdaC_ + lambda, phi);
        }
        phiRad = 0.7853981633974483;
        for (int iter = 0; iter < 33; ++iter) {
            double cosHalfPhi = Math.cos(0.5 * phiRad);
            double tanHalfPhi = Math.tan(0.5 * phiRad);
            double dphiRad = -(2.8284271247461903 * (phiRad - 0.7853981633974483) - Math.log(tanHalfPhi) - yOverRS) / (2.8284271247461903 - 0.5 * cosHalfPhi * cosHalfPhi / tanHalfPhi);
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ / (Math.cos(phiRad) * (2.8284271247461903 - 1.0 / Math.sin(phiRad)));
        double lon = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        if (y < 0.0) {
            phiRad = -phiRad;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BakerDinomic bakerDinomic = this;
        synchronized (bakerDinomic) {
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double lambda;
                double x;
                int ix;
                double phi;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                if (y <= this.joinYRS_) {
                    double lambdaRad;
                    phiRad = 2.0 * Math.atan(Math.exp(yOverRS)) - 1.5707963267948966;
                    if (y < 0.0) {
                        phiRad = -phiRad;
                    }
                    phi = Math.toDegrees(phiRad);
                    for (ix = -this.dxMax_; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                        lambda = Math.toDegrees(lambdaRad);
                        this.setPoint(ix, iy, this.lambdaC_ + lambda, phi);
                        this.setPoint(ix, -iy, this.lambdaC_ + lambda, -phi);
                    }
                    continue;
                }
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    double cosHalfPhi = Math.cos(0.5 * phiRad);
                    double tanHalfPhi = Math.tan(0.5 * phiRad);
                    double dphiRad = -(2.8284271247461903 * (phiRad - 0.7853981633974483) - Math.log(tanHalfPhi) - yOverRS) / (2.8284271247461903 - 0.5 * cosHalfPhi * cosHalfPhi / tanHalfPhi);
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                if (phiRad > 1.5707963267948966) break;
                phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ / (Math.cos(phiRad) * (2.8284271247461903 - 1.0 / Math.sin(phiRad)));
                for (ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    x = (double)ix + 0.5;
                    lambda = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad > 0.0);
                    if (!Double.isNaN(lambda)) {
                        this.setPoint(ix, iy, lambda, phi);
                    }
                    if (Double.isNaN(lambda = this.getLongitudeForX(x, xFactor, this.invRS_, phiRad < 0.0))) continue;
                    this.setPoint(ix, -iy, lambda, -phi);
                }
            }
        }
    }
}

