/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.overlay.OutlineSegment;
import gov.nasa.giss.map.shapefile.ShapeRecord;
import gov.nasa.giss.map.shapefile.Shapefile;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ShapefileOverlay
extends OutlineOverlay {
    public ShapefileOverlay(File f) throws FileNotFoundException, IOException {
        super(f);
    }

    public ShapefileOverlay(URL url) throws IOException {
        super(url);
    }

    public ShapefileOverlay(byte[] bytes, String id) throws IOException {
        super(bytes, id);
    }

    @Override
    protected boolean readHeader(InputStream istream) throws IOException {
        new Shapefile(istream);
        return true;
    }

    @Override
    protected void readFullContent(InputStream istream) throws IOException {
        Shapefile sfile = new Shapefile(istream);
        LonLatBounds bounds = sfile.getBounds();
        this.setBounds(bounds);
        int numShapes = sfile.size();
        for (int i = 0; i < numShapes; ++i) {
            OutlineSegment.SegmentType stype;
            ShapeRecord shape = sfile.getShape(i);
            if (shape.isNull() || shape.isMultiPatch()) continue;
            if (shape.isPoint() || shape.isMultiPoint()) {
                stype = OutlineSegment.SegmentType.POINTS;
            } else if (shape.isPolyline()) {
                stype = OutlineSegment.SegmentType.SHAPES;
            } else {
                if (!shape.isPolygon()) continue;
                stype = OutlineSegment.SegmentType.SHAPES;
            }
            OutlineArea area = new OutlineArea();
            area.setBounds(shape.getBounds());
            int numParts = shape.numberOfParts();
            for (int j = 0; j < numParts; ++j) {
                Point2D.Double[] pts = shape.getPoints(j);
                OutlineSegment segment = new OutlineSegment(stype);
                for (int k = 0; k < pts.length; ++k) {
                    if (pts[k].y > 90.0) {
                        pts[k].y = 90.0;
                    } else if (pts[k].y < -90.0) {
                        pts[k].y = -90.0;
                    }
                    PointLL p = new PointLL(pts[k].x, pts[k].y);
                    segment.addPoint(p);
                }
                if (segment.size() <= 0) continue;
                area.addSegment(segment);
            }
            if (area.size() <= 0) continue;
            this.addArea(area);
        }
        this.setContentRead();
    }
}

