/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.map.MapUtils;

public class MapOverlay {
    private static final String PATH_SEP = System.getProperty("file.separator");
    protected Object address_;
    private String name_;
    private double[] bounds_ = new double[]{-180.0, 90.0, 180.0, -90.0};

    protected void setIdentifier(String id) {
        StringBuilder sb = new StringBuilder("");
        int lastSeparator = id.lastIndexOf(PATH_SEP);
        int lastSlash = id.lastIndexOf(47);
        if (lastSlash > lastSeparator) {
            lastSeparator = lastSlash;
        }
        sb.append(id.substring(lastSeparator + 1));
        this.name_ = sb.toString();
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public LonLatBounds getBounds() {
        return new LonLatBounds(this.bounds_[0], this.bounds_[1], this.bounds_[2], this.bounds_[3]);
    }

    public void setBounds(double west, double north, double east, double south) {
        double ee;
        if (south >= north) {
            throw new IllegalArgumentException("South lat must be less than north.");
        }
        if (Math.abs(north) > 90.0) {
            throw new IllegalArgumentException("North lat out of valid range.");
        }
        if (Math.abs(south) > 90.0) {
            throw new IllegalArgumentException("South lat out of valid range.");
        }
        if (Math.abs(west) > 720.0 || Math.abs(east) > 720.0) {
            throw new IllegalArgumentException("Lons should be specified with reasonable values.");
        }
        if (Math.abs(east - west) > 360.0) {
            throw new IllegalArgumentException("East and west lons must be within 360 deg.");
        }
        if (west == east || west == east + 360.0) {
            throw new IllegalArgumentException("East and west lons cannot be same meridian.");
        }
        double ww = MapUtils.normalizeMP180(west);
        for (ee = MapUtils.normalizeMP180(east); ee <= ww; ee += 360.0) {
        }
        this.bounds_ = new double[]{ww, north, ee, south};
    }

    public void setBounds(LonLatBounds bb) {
        this.setBounds(bb.getWest(), bb.getNorth(), bb.getEast(), bb.getSouth());
    }

    public void setBounds(double[] bb) {
        if (bb.length != 4) {
            throw new IllegalArgumentException("Bounds array should have 4 items.");
        }
        this.setBounds(bb[0], bb[1], bb[2], bb[3]);
    }
}

