/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.landmarks;

import java.awt.Color;

public abstract class Satellite {
    public static final int NATURAL = 101;
    public static final int MANMADE = 102;
    public static final int UNKNOWN = 99;
    private double longitude_ = Double.NaN;
    private double latitude_ = Double.NaN;
    private double altitude_ = Double.NaN;
    private boolean markIt_;
    private int type_ = 99;
    private String code_;
    private String name_;
    private Color color_ = Color.WHITE;

    public Satellite(int type, double lon, double lat, double alt, String code, String name) {
        this(type, lon, lat, alt, code, name, Color.GREEN);
    }

    public Satellite(int type, double lon, double lat, double alt, String code, String name, Color color) {
        this.type_ = type;
        this.longitude_ = lon;
        this.latitude_ = lat;
        this.altitude_ = alt;
        this.markIt_ = false;
        this.code_ = code;
        this.name_ = name;
        this.color_ = color;
    }

    public abstract void update();

    public int getType() {
        return this.type_;
    }

    public double getLongitude() {
        return this.longitude_;
    }

    public void setLongitude(double d) {
        this.longitude_ = d;
    }

    public double getLatitude() {
        return this.latitude_;
    }

    public void setLatitude(double d) {
        this.latitude_ = d;
    }

    public double getAltitude() {
        return this.altitude_;
    }

    public void setAltitude(double d) {
        this.altitude_ = d;
    }

    public String getName() {
        return this.name_;
    }

    public String getCode() {
        return this.code_;
    }

    public boolean isMarked() {
        return this.markIt_;
    }

    public void setMarked(boolean b) {
        if (b == this.markIt_) {
            return;
        }
        this.markIt_ = b;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color c) {
        if (c.equals(this.color_)) {
            return;
        }
        this.color_ = c;
    }

    public int compareTo(Satellite other) {
        if (this.type_ > other.getType()) {
            return 1;
        }
        if (this.type_ < other.getType()) {
            return -1;
        }
        return this.name_.compareTo(other.getName());
    }
}

