/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NclRgbColorTable
extends AbstractColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NclRgbColorTable() {
        this(100);
    }

    public NclRgbColorTable(int count) {
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("RGB");
    }

    public NclRgbColorTable(File f) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        try (FileReader fr = new FileReader(f);
             BufferedReader br = new BufferedReader(fr);){
            this.parseColorTable(br);
        }
    }

    public NclRgbColorTable(URL url) throws IOException, FileNotFoundException, ParseException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             InputStreamReader isr = new InputStreamReader(bis);
             BufferedReader br = new BufferedReader(isr);){
            this.parseColorTable(br);
        }
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        NclRgbColorTable c = new NclRgbColorTable(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        ArrayList<Color> colors = new ArrayList<Color>(256);
        int linesRead = 0;
        String oneLine = bReader.readLine();
        while ((oneLine = bReader.readLine()) != null) {
            ++linesRead;
            if (oneLine.startsWith("ncolor") || oneLine.startsWith("ncolors") || oneLine.charAt(0) == '#' || oneLine.length() == 0) continue;
            int comment = Math.min(oneLine.indexOf(59), oneLine.indexOf(35));
            if (comment > 0) {
                oneLine = oneLine.substring(0, comment - 1);
            }
            oneLine = oneLine.replaceFirst("^\\s+", "");
            String[] tokens = (oneLine = oneLine.replaceFirst("\\s+$", "")).split("\\s+");
            int numTokens = tokens.length;
            if (numTokens < 1 || numTokens == 1 && tokens[0].length() == 0) continue;
            if (numTokens != 3) {
                throw new ParseException("Bad token count", 0);
            }
            try {
                float r1 = Float.parseFloat(tokens[0]);
                float g1 = Float.parseFloat(tokens[1]);
                float b1 = Float.parseFloat(tokens[2]);
                if (r1 <= 1.0f && g1 <= 1.0f && b1 <= 1.0f) {
                    colors.add(new Color(r1, g1, b1));
                    continue;
                }
                colors.add(new Color((int)r1, (int)g1, (int)b1));
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    exc.printStackTrace();
                }
                throw new ParseException("Exception parsing RGB file", linesRead);
            }
        }
        int count = colors.size();
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            this.setColorAt(i, (Color)colors.get(i));
        }
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        block27: {
            int ccount = this.getColorCount();
            try (FileWriter fw = new FileWriter(f);
                 BufferedWriter out = new BufferedWriter(fw);){
                out.write("ncolors=" + ccount + "\n");
                out.write("# r g b\n");
                for (int i = 0; i < ccount; ++i) {
                    Color c = this.getColorAt(i);
                    out.write(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + "\n");
                }
            }
            catch (Exception exc) {
                LOGGER.error("Failed to save color table due to {}", exc);
                if (!LOGGER.isTraceEnabled()) break block27;
                exc.printStackTrace();
            }
        }
        return false;
    }
}

