/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.util.List;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;

public class NcArrayLonLatMSGNavigation
extends NcArrayLonLatProjected {
    private ProjectionImpl njProj_;

    public NcArrayLonLatMSGNavigation(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.MSG_NAV);
        this.initMe();
    }

    private final void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.MSG_NAV)) {
            throw new NcException("Variable is not projected type MSG navigation.");
        }
        this.initUnidataProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof MSGnavigation)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of MSGnavigation");
        }
        this.njProj_ = pj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        return NcArrayLonLatMSGNavigation.transformNjLL2XY(this.njProj_, lon, lat);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        return NcArrayLonLatMSGNavigation.transformNjXY2LL(this.njProj_, x, y);
    }
}

