/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAltGridding;
import gov.nasa.giss.data.nc.NcAltGriddingVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection;

public class NcArrayLonLatCylindricalEqualArea
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private ProjectionImpl njProj_;
    private double cosPhiTS_ = 1.0;
    private double oneOverCosPhiTS_ = 1.0;

    public NcArrayLonLatCylindricalEqualArea(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.CYL_EQUAL_AREA);
        LOGGER.trace("");
        this.initMe();
    }

    private final void initMe() {
        LOGGER.trace("");
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcAltGriddingVarType)vtype).isGrid(NcAltGridding.CYL_EQUAL_AREA)) {
            throw new NcException("Variable is not projected type cylindrical equal area.");
        }
        this.initGissProj();
    }

    private final void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List<CoordinateSystem> csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate systems found.");
        }
        CoordinateSystem cs = csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (!(pj instanceof CylindricalEqualAreaProjection)) {
            throw new NcException("CoordinateSystem returned " + pj.getClass() + " instead of CylindricalEqualArea");
        }
        this.njProj_ = pj;
    }

    private final void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("cylindrical_equal_area") && !this.mappingName_.equalsIgnoreCase("lambert_cylindrical_equal_area")) {
            throw new NcException("Mapping name is not cylindrical_equal_area or lambert_cylindrical_equal_area");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        Attribute parallelsA = this.mappingVarDS_.findAttribute("standard_parallel");
        if (parallelsA == null) {
            throw new NcException("Coordinate transform variable is missing standard parallel");
        }
        double phiTS = parallelsA.getNumericValue().doubleValue();
        double phiTSRad = Math.toRadians(phiTS);
        this.cosPhiTS_ = Math.cos(phiTSRad);
        if (this.cosPhiTS_ == 0.0) {
            LOGGER.warn("Latitude of true scale is at the pole.");
            this.oneOverCosPhiTS_ = Double.NaN;
        } else {
            this.oneOverCosPhiTS_ = 1.0 / this.cosPhiTS_;
        }
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double phiRad = Math.toRadians(lat);
        double x = this.cosPhiTS_ * lambdaRad;
        double y = Math.sin(phiRad) * this.oneOverCosPhiTS_;
        return new Point2D.Double(x * this.rS_ + this.falseEasting_, y * this.rS_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double phiRad = Math.asin(yy * this.cosPhiTS_ * this.oneOverRS_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = xx * this.oneOverRS_ * this.oneOverCosPhiTS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }
}

