/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced;
import gov.nasa.giss.map.LonLatBounds;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatReducedCF
extends NcArrayLonLatReduced {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcArrayLonLatReducedCF(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private final void initMe() {
        int i;
        Array latArray;
        Array lonArray;
        Dimension latDim;
        List<CoordinateSystem> l = this.njvarDS_.getCoordinateSystems();
        if (l == null || l.isEmpty()) {
            throw new NcException("Coordinate system not found");
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            throw new NcException("Coordinate system not found");
        }
        this.lonVarDS_ = cs.getLonAxis();
        this.latVarDS_ = cs.getLatAxis();
        if (this.lonVarDS_ == null || this.latVarDS_ == null) {
            throw new NcException("Lon or lat variable not found");
        }
        if (!(this.lonVarDS_ instanceof CoordinateAxis1D)) {
            throw new NcException("Longitude is not CoordinateAxis1D");
        }
        if (!(this.latVarDS_ instanceof CoordinateAxis1D)) {
            throw new NcException("Latitude is not CoordinateAxis1D");
        }
        int[] lonshape = this.lonVarDS_.getShape();
        if (lonshape.length != 1 || lonshape[0] < 2) {
            throw new NcException("Bad longitude variable shape");
        }
        int[] latshape = this.latVarDS_.getShape();
        if (latshape.length != 1 || latshape[0] < 2) {
            throw new NcException("Bad latitude variable shape");
        }
        Dimension lonDim = this.lonVarDS_.getDimension(0);
        if (!lonDim.equals(latDim = this.latVarDS_.getDimension(0))) {
            throw new NcException("Lon and lat vars have different lengths");
        }
        int rank = this.njvarDS_.getRank();
        for (int i2 = 0; i2 < rank; ++i2) {
            Dimension d = this.njvarDS_.getDimension(i2);
            if (!d.equals(lonDim)) continue;
            this.reduceDimIndex_ = i2;
            break;
        }
        if (this.reduceDimIndex_ < 0) {
            throw new NcException("Var does not seem to use the compressed grid dimension used by lon/lat vars");
        }
        try {
            lonArray = this.lonVarDS_.read();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lon axis array");
        }
        try {
            latArray = this.latVarDS_.read();
        }
        catch (Exception exc) {
            throw new NcException("Could not read lat axis array");
        }
        this.numPts_ = (int)lonArray.getSize();
        this.rawLonValues_ = new double[this.numPts_];
        this.rawLatValues_ = new double[this.numPts_];
        for (int i3 = 0; i3 < this.numPts_; ++i3) {
            this.rawLonValues_[i3] = lonArray.getDouble(i3);
            this.rawLatValues_[i3] = latArray.getDouble(i3);
        }
        ArrayList<Double> latValuesAL = new ArrayList<Double>((int)Math.sqrt(this.numPts_));
        ArrayList<Integer> latOffsetsAL = new ArrayList<Integer>(latValuesAL.size());
        double lastLat = -9999.0;
        for (i = 0; i < this.numPts_; ++i) {
            double lat = this.rawLatValues_[i];
            if (lat == lastLat) continue;
            lastLat = lat;
            latValuesAL.add(lat);
            latOffsetsAL.add(i);
        }
        this.numRows_ = latValuesAL.size();
        this.rowLatValues_ = new double[this.numRows_];
        this.latOffsets_ = new int[this.numRows_];
        for (i = 0; i < this.numRows_; ++i) {
            this.rowLatValues_[i] = (Double)latValuesAL.get(i);
            this.latOffsets_[i] = (Integer)latOffsetsAL.get(i);
        }
        this.cellsInRow_ = new int[this.numRows_];
        for (i = 0; i < this.numRows_; ++i) {
            this.cellsInRow_[i] = i < this.numRows_ - 1 ? this.latOffsets_[i + 1] - this.latOffsets_[i] : this.numPts_ - this.latOffsets_[i];
            if (this.cellsInRow_[i] <= this.maxCols_) continue;
            this.maxCols_ = this.cellsInRow_[i];
        }
        this.yAxis_ = new NcAxis(NcAxisType.LAT, "Latitude", this.rowLatValues_);
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatReducedCF.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        Dimension d2;
        List<CoordinateSystem> l = varDS.getCoordinateSystems();
        if (l == null || l.isEmpty()) {
            return false;
        }
        CoordinateSystem cs = l.get(0);
        if (cs == null) {
            return false;
        }
        CoordinateAxis lonax = cs.getLonAxis();
        CoordinateAxis latax = cs.getLatAxis();
        if (lonax == null || latax == null) {
            return false;
        }
        if (!(lonax instanceof CoordinateAxis1D)) {
            return false;
        }
        if (!(latax instanceof CoordinateAxis1D)) {
            return false;
        }
        int[] lonshape = lonax.getShape();
        int[] latshape = latax.getShape();
        if (lonshape.length != 1 || lonshape[0] < 2) {
            return false;
        }
        if (latshape.length != 1 || latshape[0] < 2) {
            return false;
        }
        Dimension d1 = lonax.getDimension(0);
        if (!d1.equals(d2 = latax.getDimension(0))) {
            return false;
        }
        int rank = varDS.getRank();
        boolean found = false;
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            if (!d.equals(d1)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        VariableDS cv = ncd.getNjCoordinateVariable(d1);
        if (cv == null) {
            return false;
        }
        Attribute compressA = cv.findAttribute("compress");
        if (compressA == null) {
            return false;
        }
        String compress = compressA.getStringValue();
        String[] tokens = compress.split(" ");
        if (tokens.length != 2) {
            return false;
        }
        Dimension dd1 = ncd.getNjDimension(tokens[0]);
        Dimension dd2 = ncd.getNjDimension(tokens[1]);
        return dd1 != null && dd2 != null;
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        sb.append("Not yet implemented");
    }

    @Override
    public LonLatBounds getLonLatBounds() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }
}

