/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayUtils;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderFeatureTypeTrajectory;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.TimeFormatter;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcArrayDiscreteTrajectoryProfile
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TContent tcontent_ = TContent.SINGLE;
    private VariableDS lonVarDS_;
    private VariableDS latVarDS_;
    private VariableDS timeVarDS_;
    private Array lonArray_;
    private Array latArray_;
    private Array vertArray_;
    private Array timeArray_;
    private Index llCVIndex_;
    private Index vertCVIndex_;
    private Index timeCVIndex_;
    private boolean vertVarIs2D_;
    private boolean vertVarIs3D_;
    private boolean timeVarIsNumeric_;
    private boolean timeVarIsFloat_;
    private TimeFormatter timeParser_;
    protected int elemDimNum_ = -1;
    private int instanceDimNum_ = -1;
    private int cvInstanceDimNum_ = -1;
    protected NcAxis elemAxis_;
    private int elemAxisLength_ = -1;
    private int crntInstance_;
    private boolean needsCVSlice_ = true;

    public NcArrayDiscreteTrajectoryProfile(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private final void initMe() {
        VariableDS[] gridvars = NcArrayDiscreteTrajectoryProfile.getCoordinateVars(this.dataset_, this.njvarDS_);
        if (gridvars == null) {
            throw new NcException("Got null retrieving LON/LAT coordinate variable(s)");
        }
        this.lonVarDS_ = gridvars[0];
        this.latVarDS_ = gridvars[1];
        this.timeVarDS_ = gridvars[2];
        Dimension elemAxisDim = null;
        Dimension instanceAxisDim = null;
        int llRank = this.lonVarDS_.getRank();
        if (llRank == 1) {
            this.tcontent_ = TContent.SINGLE;
            elemAxisDim = this.lonVarDS_.getDimension(0);
        } else if (llRank == 2) {
            Dimension time1d = null;
            if (this.timeVarDS_ == null) {
                this.tcontent_ = TContent.MULTI_TIME1D;
            } else if (this.timeVarDS_.getRank() == 1) {
                this.tcontent_ = TContent.MULTI_TIME1D;
                if (NcVarUtils.isRelativeTimeVar(null, this.timeVarDS_)) {
                    time1d = this.timeVarDS_.getDimension(0);
                }
            } else {
                this.tcontent_ = TContent.MULTI_CF;
                elemAxisDim = this.timeVarDS_.getDimension(1);
                this.cvInstanceDimNum_ = 0;
            }
            for (int i = 0; i < 2; ++i) {
                Dimension dd = this.lonVarDS_.getDimension(i);
                if ((time1d == null || dd != time1d) && !NcArrayDiscreteTrajectoryProfile.isElementDimensionName(dd.getShortName())) continue;
                elemAxisDim = dd;
                this.cvInstanceDimNum_ = 1 - i;
                break;
            }
            if (elemAxisDim == null) {
                elemAxisDim = this.lonVarDS_.getDimension(1);
                this.cvInstanceDimNum_ = 0;
            }
            instanceAxisDim = this.lonVarDS_.getDimension(this.cvInstanceDimNum_);
        } else {
            throw new NcException("CVs have unexpected rank: " + llRank);
        }
        if (this.timeVarDS_ != null) {
            DataType dtype = this.timeVarDS_.getDataType();
            this.timeVarIsNumeric_ = dtype.isNumeric();
            this.timeVarIsFloat_ = dtype.isFloatingPoint();
            if (this.timeVarIsNumeric_ && NcVarUtils.isRelativeTimeVar(this.dataset_, this.timeVarDS_)) {
                try {
                    this.timeParser_ = NcVarUtils.getRelativeTimeHandler(this.dataset_, this.timeVarDS_);
                }
                catch (Exception exc) {
                    LOGGER.debug("Could not construct relative-time parser");
                }
            }
        } else {
            this.timeVarIsNumeric_ = true;
        }
        if (elemAxisDim == null) {
            throw new NcException("Got null for trajectory's obs/time dimension");
        }
        String elemAxisName = elemAxisDim.getShortName();
        this.elemAxisLength_ = elemAxisDim.getLength();
        this.elemAxis_ = new NcAxis(NcAxisType.TIME, elemAxisName, this.elemAxisLength_);
        this.elemDimNum_ = this.findDimensionIndex(elemAxisName);
        if (this.tcontent_ != TContent.SINGLE) {
            if (instanceAxisDim == null) {
                throw new NcException("Got null for trajectory's instance dimension");
            }
            String instanceAxisName = instanceAxisDim.getShortName();
            this.instanceDimNum_ = this.findDimensionIndex(instanceAxisName);
        }
        this.rank_ = this.njvarDS_.getRank();
        this.shape_ = this.njvarDS_.getShape();
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.elemDimNum_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getLength() {
        return this.elemAxisLength_;
    }

    public NcAxis getAxis() {
        return this.elemAxis_;
    }

    public int getDimensionIndex() {
        return this.elemDimNum_;
    }

    public PointLL lonLatAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            return null;
        }
        if (this.needsCVSlice_ || this.lonArray_ == null) {
            this.doCVSlice();
        }
        try {
            this.llCVIndex_.set(index);
        }
        catch (Exception exc) {
            LOGGER.debug("Exception! index {}, lcvIndex {}", (Object)index, (Object)this.llCVIndex_);
            return null;
        }
        double lon = this.lonArray_.getDouble(this.llCVIndex_);
        double lat = this.latArray_.getDouble(this.llCVIndex_);
        if (Double.isNaN(lon) || Double.isNaN(lat)) {
            return null;
        }
        if (lon > 7200.0 || lon < -7200.0) {
            return null;
        }
        return new PointLL(lon, lat);
    }

    public Object vertAt(int index, int vindex) {
        return null;
    }

    public Object timeAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            return null;
        }
        if (this.timeVarDS_ == null) {
            return index;
        }
        if (this.needsCVSlice_ || this.timeArray_ == null) {
            this.doCVSlice();
        }
        try {
            this.timeCVIndex_.set(index);
        }
        catch (Exception exc) {
            LOGGER.debug("Exception! {}", exc);
            LOGGER.debug("index {}, tcvIndex {}", (Object)index, (Object)this.timeCVIndex_);
            return null;
        }
        Object tval = null;
        if (this.timeVarIsFloat_) {
            tval = this.timeArray_.getDouble(this.timeCVIndex_);
            if (this.timeParser_ != null) {
                tval = this.timeParser_.format((Double)tval);
            }
        } else if (this.timeVarIsNumeric_) {
            tval = this.timeArray_.getLong(this.timeCVIndex_);
            if (this.timeParser_ != null) {
                tval = this.timeParser_.format((Long)tval);
            }
        } else {
            tval = this.timeArray_.getObject(this.timeCVIndex_);
        }
        return tval;
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.elemAxisLength_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + " : " + this.elemAxisLength_);
        }
        if (this.needsSlice_ || this.slice_ == null) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        super.setSliceIndex(dimNum, index);
        if (this.tcontent_ != TContent.SINGLE && dimNum == this.instanceDimNum_) {
            this.needsCVSlice_ = true;
            this.crntInstance_ = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSlice() throws NcException {
        NcArrayDiscreteTrajectoryProfile ncArrayDiscreteTrajectoryProfile = this;
        synchronized (ncArrayDiscreteTrajectoryProfile) {
            int[] sOrigin = new int[this.rank_];
            int[] sShape = new int[this.rank_];
            try {
                this.needsSlice_ = true;
                for (int i = 0; i < this.rank_; ++i) {
                    sOrigin[i] = this.sIndex_[i];
                    sShape[i] = 1;
                }
                sOrigin[this.elemDimNum_] = 0;
                sShape[this.elemDimNum_] = this.elemAxisLength_;
                this.slice_ = this.njvarDS_.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                this.needsSlice_ = false;
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException("Do Slice - " + exc.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCVSlice() throws NcException {
        NcArrayDiscreteTrajectoryProfile ncArrayDiscreteTrajectoryProfile = this;
        synchronized (ncArrayDiscreteTrajectoryProfile) {
            try {
                if (this.tcontent_ == TContent.SINGLE) {
                    if (this.lonArray_ == null) {
                        this.lonArray_ = this.lonVarDS_.read();
                        this.latArray_ = this.latVarDS_.read();
                        this.llCVIndex_ = this.lonArray_.getIndex();
                    }
                    if (this.timeVarDS_ != null) {
                        this.timeArray_ = this.timeVarDS_.read();
                        this.timeCVIndex_ = this.llCVIndex_;
                    }
                } else {
                    int llrank = this.lonVarDS_.getRank();
                    int[] sOrigin = new int[llrank];
                    int[] sShape = new int[llrank];
                    for (int i = 0; i < llrank; ++i) {
                        sOrigin[i] = 0;
                        sShape[i] = 1;
                    }
                    sOrigin[this.cvInstanceDimNum_] = this.crntInstance_;
                    sShape[this.elemDimNum_] = this.elemAxisLength_;
                    this.lonArray_ = this.lonVarDS_.read(sOrigin, sShape).reduce();
                    this.latArray_ = this.latVarDS_.read(sOrigin, sShape).reduce();
                    this.llCVIndex_ = this.lonArray_.getIndex();
                    if (this.timeVarDS_ != null) {
                        if (this.tcontent_ == TContent.MULTI_TIME1D) {
                            this.timeArray_ = this.timeVarDS_.read();
                            this.timeCVIndex_ = this.timeArray_.getIndex();
                        } else {
                            this.timeArray_ = this.timeVarDS_.read(sOrigin, sShape).reduce();
                            this.timeCVIndex_ = this.llCVIndex_;
                        }
                    }
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to read trajectory coordinate vars: {}", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException("Unable to read coordinate vars: " + exc.toString());
            }
            this.needsCVSlice_ = false;
        }
    }

    @Override
    protected void findExtrema() {
        block7: {
            double[] range = this.getActualRange();
            if (range != null) {
                this.minimum_ = range[0];
                this.maximum_ = range[1];
                this.needsExtrema_ = false;
                return;
            }
            this.minimum_ = Double.POSITIVE_INFINITY;
            this.maximum_ = Double.NEGATIVE_INFINITY;
            try {
                for (int j = 0; j < this.elemAxisLength_; ++j) {
                    double value = this.valueAt(j);
                    if (this.isMissingOrInvalid(value)) continue;
                    if (this.maximum_ < this.minimum_) {
                        this.minimum_ = value;
                        this.maximum_ = value;
                        continue;
                    }
                    if (value < this.minimum_) {
                        this.minimum_ = value;
                        continue;
                    }
                    if (!(value > this.maximum_)) continue;
                    this.maximum_ = value;
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Exception obtaining min and max values: {}", (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.error("{}", (Object)exc.toString());
            }
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.elemDimNum_] = index;
        this.sliceIdx_.set(ss);
        return NcArrayUtils.getDoubleFromSlice(this.slice_, this.sliceIdx_, this.hasScaleOffset_, this.isUnsigned_);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderFeatureTypeTrajectory();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        sb.append("Not yet implemented");
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS, boolean requireFeatureType) {
        LOGGER.trace("var {}", (Object)varDS.getShortName());
        NcGeometryType geometry = ncd.getGeometry();
        if (requireFeatureType && geometry != NcGeometryType.TRAJECTORY_PROFILE) {
            LOGGER.debug("Feature type attribute req'd but global metadata does not match.");
            return false;
        }
        if (geometry == NcGeometryType.POINT || geometry == NcGeometryType.TIME_SERIES || geometry == NcGeometryType.PROFILE || geometry == NcGeometryType.TIME_SERIES_PROFILE || geometry == NcGeometryType.TRAJECTORY) {
            LOGGER.debug("Discrete feature type is specified but is not a trajectory.");
            return false;
        }
        VariableDS[] vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVars(ncd, varDS);
        return vars != null;
    }

    private static VariableDS[] getCoordinateVars(NcDataset ncd, VariableDS varDS) {
        VariableDS[] vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVarsCS(varDS);
        if (vars != null) {
            return vars;
        }
        return NcArrayDiscreteTrajectoryProfile.getCoordinateVarsNoCS(ncd, varDS);
    }

    private static VariableDS[] getCoordinateVarsCS(VariableDS varDS) {
        List<CoordinateSystem> csList = varDS.getCoordinateSystems();
        LOGGER.trace("csList {}", (Object)csList);
        if (csList == null || csList.isEmpty()) {
            return null;
        }
        CoordinateSystem cs = csList.get(0);
        LOGGER.trace("cs {}", (Object)cs);
        if (cs == null) {
            return null;
        }
        LOGGER.trace("Coordinate system found");
        CoordinateAxis lonCV = cs.getLonAxis();
        CoordinateAxis latCV = cs.getLatAxis();
        CoordinateAxis vertCV = cs.getZaxis();
        CoordinateAxis timeCV = cs.getTaxis();
        LOGGER.trace("lon {}, lat {}, vert {}, time {}", lonCV != null, latCV != null, vertCV != null, timeCV != null);
        if (lonCV == null || latCV == null) {
            return null;
        }
        boolean good = NcArrayDiscreteTrajectoryProfile.validateCoordinateVars(lonCV, latCV, vertCV, timeCV);
        if (good) {
            return new VariableDS[]{lonCV, latCV, vertCV, timeCV};
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsNoCS(NcDataset ncd, VariableDS varDS) {
        String[] tokens = NcVarUtils.parseCoordinatesAttribute(varDS);
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        VariableDS[] vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVarsAtPaths(ncd, tokens);
        if (vars == null) {
            vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVarsUpOneLevel(ncd, varDS, tokens);
        }
        if (vars == null) {
            return null;
        }
        boolean good = NcArrayDiscreteTrajectoryProfile.validateCoordinateVars(vars[0], vars[1], vars[2], vars[3]);
        if (good) {
            return new VariableDS[]{vars[0], vars[1], vars[2], vars[3]};
        }
        return null;
    }

    private static VariableDS[] getCoordinateVarsAtPaths(NcDataset ncd, String[] tokens) {
        VariableDS lonVarDS = null;
        VariableDS latVarDS = null;
        VariableDS timeVarDS = null;
        for (String token : tokens) {
            String stdname;
            VariableDS tokenVar = ncd.getNjVariable(token);
            if (tokenVar == null) continue;
            String unitsStr = NcVarUtils.getUnitsString(tokenVar);
            String sname = tokenVar.getShortName();
            if (NcUnitUtils.isDegreesEast(unitsStr) || "longitude".equalsIgnoreCase(sname) || "lon".equalsIgnoreCase(sname)) {
                lonVarDS = tokenVar;
                continue;
            }
            if (NcUnitUtils.isDegreesNorth(unitsStr) || "latitude".equalsIgnoreCase(sname) || "lat".equalsIgnoreCase(sname)) {
                latVarDS = tokenVar;
                continue;
            }
            if (NcVarUtils.isRelativeTimeVar(ncd, tokenVar)) {
                timeVarDS = tokenVar;
                continue;
            }
            Attribute a = tokenVar.findAttributeIgnoreCase("standard_name");
            if (a == null || !"time".equalsIgnoreCase(stdname = a.getStringValue())) continue;
            timeVarDS = tokenVar;
        }
        if (lonVarDS == null || latVarDS == null || timeVarDS == null) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS, timeVarDS};
    }

    private static VariableDS[] getCoordinateVarsUpOneLevel(NcDataset ncd, VariableDS varDS, String[] tokens) {
        String varFullName = varDS.getFullName();
        int slash = varFullName.lastIndexOf(47);
        if (slash < 0) {
            return null;
        }
        if (tokens[0].lastIndexOf(47) >= 0) {
            return null;
        }
        String[] tokens2 = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i] = varFullName.substring(0, slash + 1) + tokens[i];
        }
        VariableDS[] vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVarsAtPaths(ncd, tokens2);
        if (vars != null) {
            return vars;
        }
        String pgroup = varFullName.substring(0, slash);
        int pslash = pgroup.lastIndexOf(47);
        if (pslash > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                tokens2[i] = varFullName.substring(0, pslash + 1) + tokens[i];
            }
            vars = NcArrayDiscreteTrajectoryProfile.getCoordinateVarsAtPaths(ncd, tokens2);
        }
        return vars;
    }

    private static boolean validateCoordinateVars(VariableDS lonCV, VariableDS latCV, VariableDS vertCV, VariableDS timeCV) {
        boolean nullTime;
        Objects.requireNonNull(lonCV, "lon CV cannot be null");
        Objects.requireNonNull(latCV, "lat CV cannot be null");
        Objects.requireNonNull(vertCV, "vert CV cannot be null");
        boolean bl = nullTime = timeCV == null;
        if (nullTime) {
            LOGGER.trace("time CV is null, but we'll try to work with it");
        }
        int lonRank = lonCV.getRank();
        int latRank = latCV.getRank();
        int vertRank = vertCV.getRank();
        int timeRank = nullTime ? 0 : timeCV.getRank();
        LOGGER.trace("ranks lon {}, lat {}, vert {}, time {}", lonRank, latRank, vertRank, timeRank);
        if (lonRank != latRank) {
            return false;
        }
        boolean singleTraj = lonRank == 1 && timeRank < 2;
        boolean multiCFTraj = lonRank == 2 && timeRank == 2;
        boolean multiXTraj = lonRank == 2 && timeRank < 2;
        boolean good = false;
        try {
            if (singleTraj) {
                good = NcArrayDiscreteTrajectoryProfile.validateSingleTrajectory(lonCV, latCV, vertCV, timeCV);
            } else if (multiCFTraj) {
                good = NcArrayDiscreteTrajectoryProfile.validateMultiTrajectoryCF(lonCV, latCV, vertCV, timeCV);
            } else if (multiXTraj) {
                good = NcArrayDiscreteTrajectoryProfile.validateMultiTrajectoryX(lonCV, latCV, vertCV, timeCV);
            }
        }
        catch (Exception exc) {
            return false;
        }
        return good;
    }

    private static boolean validateSingleTrajectory(VariableDS lonCV, VariableDS latCV, VariableDS vertCV, VariableDS timeCV) {
        LOGGER.trace("");
        Dimension londd = lonCV.getDimension(0);
        Dimension latdd = latCV.getDimension(0);
        if (!londd.equals(latdd)) {
            LOGGER.trace("Lon londd does not match lat latdd");
            return false;
        }
        if (timeCV != null) {
            Dimension timedd = timeCV.getDimension(0);
            if (!londd.equals(timedd)) {
                LOGGER.trace("Lon londd does not match time timedd");
                return false;
            }
            boolean isTimeCV = NcVarUtils.isRelativeTimeVar(null, timeCV);
            LOGGER.trace("isTimeCV {}", (Object)isTimeCV);
            if (isTimeCV) {
                return true;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            String dname = londd.getShortName();
            boolean isGoodDname = dname != null && NcArrayDiscreteTrajectoryProfile.isElementDimensionName(dname);
            LOGGER.trace("londd {} has recognized element name {}", (Object)dname, (Object)isGoodDname);
        }
        return true;
    }

    private static boolean validateMultiTrajectoryCF(VariableDS lonCV, VariableDS latCV, VariableDS vertCV, VariableDS timeCV) {
        LOGGER.trace("");
        for (int i = 0; i < 2; ++i) {
            Dimension londim = lonCV.getDimension(i);
            Dimension latdim = latCV.getDimension(i);
            Dimension timedim = timeCV.getDimension(i);
            if (londim.equals(latdim) && londim.equals(timedim)) continue;
            return false;
        }
        Dimension dd = lonCV.getDimension(1);
        String dname = dd.getShortName();
        LOGGER.trace("londd {} has recognized element name {}", (Object)NcArrayDiscreteTrajectoryProfile.isElementDimensionName(dname));
        return true;
    }

    private static boolean validateMultiTrajectoryX(VariableDS lonCV, VariableDS latCV, VariableDS vertCV, VariableDS timeCV) {
        LOGGER.trace("");
        for (int i = 0; i < 2; ++i) {
            Dimension latdim;
            Dimension londim = lonCV.getDimension(i);
            if (londim.equals(latdim = latCV.getDimension(i))) continue;
            return false;
        }
        if (timeCV != null) {
            Dimension tdim = timeCV.getDimension(0);
            if (!lonCV.getDimension(0).equals(tdim) && !lonCV.getDimension(1).equals(tdim)) {
                return false;
            }
            boolean isTimeCV = NcVarUtils.isRelativeTimeVar(null, timeCV);
            if (isTimeCV) {
                return true;
            }
            String dnameT = tdim.getShortName();
            return NcArrayDiscreteTrajectoryProfile.isElementDimensionName(dnameT);
        }
        return true;
    }

    private static boolean isElementDimensionName(String dname) {
        boolean result = "obs".equalsIgnoreCase(dname) || "sample".equalsIgnoreCase(dname) || "elem".equalsIgnoreCase(dname) || "element".equalsIgnoreCase(dname) || "source".equalsIgnoreCase(dname) || "step".equalsIgnoreCase(dname) || "tdim".equalsIgnoreCase(dname) || "time".equalsIgnoreCase(dname) || "vector1".equalsIgnoreCase(dname);
        LOGGER.trace("result {}", (Object)result);
        return result;
    }

    private static enum TContent {
        SINGLE,
        MULTI_CF,
        MULTI_TIME1D;

    }
}

