/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcVarType;

public class NcDiscreteVarType
extends NcVarType {
    private final NcGeometryType geom_;
    private boolean lonlat_;

    public NcDiscreteVarType(NcGeometryType geom) {
        super(NcVarType.VarType.DISCRETE);
        this.geom_ = geom;
        if (this.isTrajectory()) {
            this.lonlat_ = true;
        }
    }

    public NcGeometryType getGeometry() {
        return this.geom_;
    }

    public boolean isPoint() {
        return this.geom_ == NcGeometryType.POINT;
    }

    public final boolean isTrajectory() {
        return this.geom_ == NcGeometryType.TRAJECTORY;
    }

    @Override
    public boolean isGeoreferenced() {
        return this.lonlat_;
    }

    @Override
    public String toString() {
        return "NcDiscreteVarType[" + (Object)((Object)this.geom_) + "]";
    }
}

