/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class AnchorPointImpl
implements AnchorPoint,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private Expression anchorPointX = null;
    private Expression anchorPointY = null;

    static AnchorPointImpl cast(org.opengis.style.AnchorPoint anchor) {
        if (anchor == null) {
            return null;
        }
        if (anchor instanceof AnchorPointImpl) {
            return (AnchorPointImpl)anchor;
        }
        AnchorPointImpl copy = new AnchorPointImpl();
        copy.setAnchorPointX(anchor.getAnchorPointX());
        copy.setAnchorPointY(anchor.getAnchorPointY());
        return copy;
    }

    public AnchorPointImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public AnchorPointImpl(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
        try {
            this.anchorPointX = filterFactory.literal(0.0);
            this.anchorPointY = filterFactory.literal(0.5);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultAnchorPoint: " + ife);
        }
    }

    public AnchorPointImpl(FilterFactory filterFactory, Expression x, Expression y) {
        this.filterFactory = filterFactory;
        this.anchorPointX = x;
        this.anchorPointY = y;
    }

    public Expression getAnchorPointX() {
        return this.anchorPointX;
    }

    public void setAnchorPointX(Expression anchorPointX) {
        this.anchorPointX = anchorPointX;
    }

    public void setAnchorPointX(double x) {
        this.anchorPointX = this.filterFactory.literal(x);
    }

    public Expression getAnchorPointY() {
        return this.anchorPointY;
    }

    public void setAnchorPointY(Expression anchorPointY) {
        this.anchorPointY = anchorPointY;
    }

    public void getAnchorPointY(double x) {
        this.anchorPointY = this.filterFactory.literal(x);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Never happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnchorPointImpl) {
            AnchorPointImpl other = (AnchorPointImpl)obj;
            return Utilities.equals(this.anchorPointX, other.anchorPointX) && Utilities.equals(this.anchorPointY, other.anchorPointY);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.anchorPointX != null) {
            result = result * 37 + this.anchorPointX.hashCode();
        }
        if (this.anchorPointY != null) {
            result = result * 37 + this.anchorPointY.hashCode();
        }
        return result;
    }
}

