/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultImageDatum
extends AbstractDatum
implements ImageDatum {
    private static final long serialVersionUID = -4304193511244150936L;
    private final PixelInCell pixelInCell;

    public DefaultImageDatum(ImageDatum datum) {
        super(datum);
        this.pixelInCell = datum.getPixelInCell();
    }

    public DefaultImageDatum(String name, PixelInCell pixelInCell) {
        this(Collections.singletonMap("name", name), pixelInCell);
    }

    public DefaultImageDatum(Map<String, ?> properties, PixelInCell pixelInCell) {
        super(properties);
        this.pixelInCell = pixelInCell;
        DefaultImageDatum.ensureNonNull("pixelInCell", pixelInCell);
    }

    @Override
    public PixelInCell getPixelInCell() {
        return this.pixelInCell;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultImageDatum that = (DefaultImageDatum)object;
            return Utilities.equals(this.pixelInCell, that.pixelInCell);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.pixelInCell.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        formatter.append(this.pixelInCell);
        formatter.setInvalidWKT(ImageDatum.class);
        return "IMAGE_DATUM";
    }
}

