/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.factory.FactoryRegistry;
import org.geotools.io.TableWriter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FactoryPrinter
implements Comparator<Class<?>> {
    @Override
    public int compare(Class<?> factory1, Class<?> factory2) {
        return Classes.getShortName(factory1).compareToIgnoreCase(Classes.getShortName(factory2));
    }

    public void list(FactoryRegistry registry, Writer out, Locale locale) throws IOException {
        ArrayList categories = new ArrayList();
        Iterator<Class<?>> it = registry.getCategories();
        while (it.hasNext()) {
            categories.add(it.next());
        }
        Collections.sort(categories, this);
        Vocabulary resources = Vocabulary.getResources(locale);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(69));
        table.nextColumn();
        table.write(resources.getString(6));
        table.nextColumn();
        table.write(resources.getString(237));
        table.nextColumn();
        table.write(resources.getString(107));
        table.nextLine();
        table.nextLine('\u2550');
        StringBuilder vendors = new StringBuilder();
        StringBuilder implementations = new StringBuilder();
        for (Class clazz : categories) {
            table.write(Classes.getShortName(clazz));
            table.nextColumn();
            Iterator providers = registry.getServiceProviders(clazz, null, null);
            while (providers.hasNext()) {
                if (implementations.length() != 0) {
                    table.write(10);
                    vendors.append('\n');
                    implementations.append('\n');
                }
                Factory provider = (Factory)providers.next();
                Citation vendor = provider.getVendor();
                vendors.append(vendor.getTitle().toString(locale));
                implementations.append(Classes.getShortClassName(provider));
                if (!(provider instanceof AuthorityFactory)) continue;
                Citation authority = ((AuthorityFactory)provider).getAuthority();
                Iterator<? extends Identifier> identifiers = authority.getIdentifiers().iterator();
                String identifier = identifiers.hasNext() ? identifiers.next().getCode().toString() : authority.getTitle().toString(locale);
                table.write(identifier);
            }
            table.nextColumn();
            table.write(vendors.toString());
            vendors.setLength(0);
            table.nextColumn();
            table.write(implementations.toString());
            implementations.setLength(0);
            table.writeHorizontalSeparator();
        }
        table.flush();
    }
}

