/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.JTSFactoryFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WKTReader2
extends WKTReader {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String NAN_SYMBOL = "NaN";
    private static final double EPSILON_SQLMM = 1.0E-8;
    private static final double M_PI = Math.PI;
    private static final double M_PI_2 = 1.5707963267948966;
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;

    public WKTReader2() {
        this(JTSFactoryFinder.getGeometryFactory(null));
    }

    public WKTReader2(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Geometry read(String wellKnownText) throws ParseException {
        StringReader reader = new StringReader(wellKnownText);
        try {
            Geometry geometry = this.read(reader);
            return geometry;
        }
        finally {
            reader.close();
        }
    }

    @Override
    public Geometry read(Reader reader) throws ParseException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        try {
            return this.readGeometryTaggedText();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private Coordinate[] getCoordinates() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private List<Coordinate> getCoordinateList(boolean openExpected) throws IOException, ParseException {
        String nextToken;
        if (openExpected && (nextToken = this.getNextEmptyOrOpener()).equals(EMPTY)) {
            return Collections.emptyList();
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates;
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        Coordinate coord = new Coordinate();
        coord.x = this.getNextNumber();
        coord.y = this.getNextNumber();
        if (this.isNumberNext()) {
            coord.z = this.getNextNumber();
        }
        this.precisionModel.makePrecise(coord);
        return coord;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                if (this.tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseError("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN);
        return null;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        this.parseError("word");
        return null;
    }

    private void parseError(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere("Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere("Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        throw new ParseException("Expected " + expected + " but found " + tokenStr);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        String type = null;
        try {
            type = this.getNextWord();
        }
        catch (IOException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
        if (type.equals("POINT")) {
            return this.readPointText();
        }
        if (type.equalsIgnoreCase("LINESTRING")) {
            return this.readLineStringText();
        }
        if (type.equalsIgnoreCase("LINEARRING")) {
            return this.readLinearRingText();
        }
        if (type.equalsIgnoreCase("POLYGON")) {
            return this.readPolygonText();
        }
        if (type.equalsIgnoreCase("MULTIPOINT")) {
            return this.readMultiPointText();
        }
        if (type.equalsIgnoreCase("MULTILINESTRING")) {
            return this.readMultiLineStringText();
        }
        if (type.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.readMultiPolygonText();
        }
        if (type.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText();
        }
        if (type.equalsIgnoreCase("CIRCULARSTRING")) {
            return this.readCircularStringText();
        }
        if (type.equalsIgnoreCase("COMPOUNDCURVE")) {
            return this.readCompoundCurveText();
        }
        if (type.equalsIgnoreCase("CURVEPOLYGON")) {
            return this.readCurvePolygonText();
        }
        throw new ParseException("Unknown geometry type: " + type);
    }

    private Point readPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate());
        this.getNextCloser();
        return point;
    }

    private LineString readLineStringText() throws IOException, ParseException {
        return this.geometryFactory.createLineString(this.getCoordinates());
    }

    private LineString readCircularStringText() throws IOException, ParseException {
        List<Coordinate> segmentized;
        List<Coordinate> coordinates = this.getCoordinateList(true);
        if (coordinates.size() < 3) {
            segmentized = coordinates;
        } else {
            segmentized = new ArrayList<Coordinate>();
            for (int i = 0; i < coordinates.size() - 1; i += 2) {
                Coordinate p1 = coordinates.get(i);
                Coordinate p2 = coordinates.get(i + 1);
                Coordinate p3 = coordinates.get(i + 2);
                List<Coordinate> segments = this.circularSegmentize(p1, p2, p3);
                segmentized.addAll(segments.subList(0, segments.size() - 1));
            }
            segmentized.add(coordinates.get(coordinates.size() - 1));
        }
        Coordinate[] array = segmentized.toArray(new Coordinate[segmentized.size()]);
        return this.geometryFactory.createLineString(array);
    }

    private List<Coordinate> circularSegmentize(Coordinate p1, Coordinate p2, Coordinate p3) {
        double radius;
        Coordinate center;
        if (Math.abs(p1.x - p3.x) < 1.0E-8 && Math.abs(p1.y - p3.y) < 1.0E-8) {
            double centerX = p1.x + (p2.x - p1.x) / 2.0;
            double centerY = p1.y + (p2.y - p1.y) / 2.0;
            center = new Coordinate();
            center.x = centerX;
            center.y = centerY;
            radius = Math.sqrt((centerX - p1.x) * (centerX - p1.x) + (centerY - p1.y) * (centerY - p1.y));
        } else {
            double temp = p2.x * p2.x + p2.y * p2.y;
            double bc = (p1.x * p1.x + p1.y * p1.y - temp) / 2.0;
            double cd = (temp - p3.x * p3.x - p3.y * p3.y) / 2.0;
            double determinate = (p1.x - p2.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p2.y);
            if (Math.abs(determinate) < 1.0E-8) {
                ArrayList<Coordinate> curve = new ArrayList<Coordinate>();
                curve.add(p1);
                curve.add(p3);
                return curve;
            }
            determinate = 1.0 / determinate;
            double centerX = (bc * (p2.y - p3.y) - cd * (p1.y - p2.y)) * determinate;
            double centerY = ((p1.x - p2.x) * cd - (p2.x - p3.x) * bc) * determinate;
            center = new Coordinate();
            center.x = centerX;
            center.y = centerY;
            radius = Math.sqrt((centerX - p1.x) * (centerX - p1.x) + (centerY - p1.y) * (centerY - p1.y));
        }
        return this.circularSegmentize(p1, p2, p3, center, radius, 32);
    }

    private List<Coordinate> circularSegmentize(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate center, double radius, int perQuad) {
        Coordinate pbuf = new Coordinate();
        double sweep = 0.0;
        double angle = 0.0;
        double increment = 0.0;
        if (radius < 0.0) {
            ArrayList<Coordinate> result = new ArrayList<Coordinate>();
            result.add(p1);
            result.add(p2);
            return result;
        }
        double a1 = Math.atan2(p1.y - center.y, p1.x - center.x);
        double a2 = Math.atan2(p2.y - center.y, p2.x - center.x);
        double a3 = Math.atan2(p3.y - center.y, p3.x - center.x);
        sweep = Math.abs(p1.x - p3.x) < 1.0E-8 && Math.abs(p1.y - p3.y) < 1.0E-8 ? Math.PI * 2 : (a1 > a2 && a2 > a3 ? a3 - a1 : (a1 < a2 && a2 < a3 ? a3 - a1 : (a1 < a2 && a1 > a3 || a2 < a3 && a1 > a3 ? a3 - a1 + Math.PI * 2 : (a1 > a2 && a1 < a3 || a2 > a3 && a1 < a3 ? a3 - a1 - Math.PI * 2 : 0.0))));
        int ptcount = (int)Math.ceil(Math.abs((double)perQuad * sweep / 1.5707963267948966));
        ArrayList<Coordinate> result = new ArrayList<Coordinate>(ptcount);
        increment = 1.5707963267948966 / (double)perQuad;
        if (sweep < 0.0) {
            increment *= -1.0;
        }
        angle = a1;
        result.add(p1);
        for (double i = 0.0; i < (double)(ptcount - 1); i += 1.0) {
            Coordinate pt = new Coordinate();
            result.add(pt);
            angle += increment;
            if (increment > 0.0 && angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (increment < 0.0 && angle < -Math.PI) {
                angle -= Math.PI * 2;
            }
            pt.x = center.x + radius * Math.cos(angle);
            pt.y = center.y + radius * Math.sin(angle);
        }
        result.add(p3);
        return result;
    }

    private LineString readCompoundCurveText() throws IOException, ParseException {
        List<LineString> lineStrings = this.getLineStrings();
        if (lineStrings.isEmpty()) {
            return this.geometryFactory.createLineString(new Coordinate[0]);
        }
        if (lineStrings.size() == 1) {
            return lineStrings.get(0);
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (LineString segment : lineStrings) {
            List<Coordinate> segmentCoordinates = Arrays.asList(segment.getCoordinates());
            coords.addAll(segmentCoordinates.subList(0, segmentCoordinates.size() - 1));
        }
        LineString last = lineStrings.get(lineStrings.size() - 1);
        Coordinate end = last.getCoordinateN(last.getNumPoints() - 1);
        coords.add(end);
        return this.geometryFactory.createLineString(coords.toArray(new Coordinate[coords.size()]));
    }

    List<LineString> getLineStrings() throws IOException, ParseException {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        String nextWord = this.getNextEmptyOrOpener();
        if (nextWord.equals(EMPTY)) {
            return lineStrings;
        }
        nextWord = COMMA;
        while (nextWord.equals(COMMA)) {
            nextWord = this.getNextWord();
            if (nextWord.equals(L_PAREN)) {
                List<Coordinate> coords = this.getCoordinateList(false);
                LineString lineString = this.geometryFactory.createLineString(coords.toArray(new Coordinate[coords.size()]));
                lineStrings.add(lineString);
            } else if (nextWord.equalsIgnoreCase("CIRCULARSTRING")) {
                LineString circularString = this.readCircularStringText();
                lineStrings.add(circularString);
            }
            nextWord = this.getNextCloserOrComma();
        }
        return lineStrings;
    }

    private LinearRing readCurvedLinearRingText() throws IOException, ParseException {
        Coordinate[] ring = null;
        String nextWord = this.getNextWord();
        if (nextWord.equals(L_PAREN)) {
            List<Coordinate> coords = this.getCoordinateList(false);
            ring = coords.toArray(new Coordinate[coords.size()]);
        } else if (nextWord.equalsIgnoreCase("CIRCULARSTRING")) {
            LineString circularString = this.readCircularStringText();
            ring = circularString.getCoordinates();
        } else if (nextWord.equalsIgnoreCase("COMPOUNDCURVE")) {
            LineString circularString = this.readCompoundCurveText();
            ring = circularString.getCoordinates();
        } else {
            this.parseError("(, CIRCULARSTRING or COMPOUNDCURVE");
        }
        return this.geometryFactory.createLinearRing(ring);
    }

    private LinearRing readLinearRingText() throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinates());
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException {
        return this.geometryFactory.createMultiPoint(this.toPoints(this.getCoordinates()));
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < coordinates.length; ++i) {
            points.add(this.geometryFactory.createPoint(coordinates[i]));
        }
        return points.toArray(new Point[0]);
    }

    private Polygon readPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        LinearRing shell = this.readLinearRingText();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private Polygon readCurvePolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        if (!nextToken.equals(L_PAREN)) {
            this.parseError("Ring expected");
        }
        LinearRing shell = this.readCurvedLinearRingText();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readCurvedLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiLineStringText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiLineString(new LineString[0]);
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        LineString lineString = this.readLineStringText();
        lineStrings.add(lineString);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            lineString = this.readLineStringText();
            lineStrings.add(lineString);
            nextToken = this.getNextCloserOrComma();
        }
        LineString[] array = new LineString[lineStrings.size()];
        return this.geometryFactory.createMultiLineString(lineStrings.toArray(array));
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Polygon polygon = this.readPolygonText();
        polygons.add(polygon);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            polygon = this.readPolygonText();
            polygons.add(polygon);
            nextToken = this.getNextCloserOrComma();
        }
        Polygon[] array = new Polygon[polygons.size()];
        return this.geometryFactory.createMultiPolygon(polygons.toArray(array));
    }

    private GeometryCollection readGeometryCollectionText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Geometry geometry = this.readGeometryTaggedText();
        geometries.add(geometry);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            geometry = this.readGeometryTaggedText();
            geometries.add(geometry);
            nextToken = this.getNextCloserOrComma();
        }
        Geometry[] array = new Geometry[geometries.size()];
        return this.geometryFactory.createGeometryCollection(geometries.toArray(array));
    }
}

