/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.media.jai.operator.ImageFunctionDescriptor;
import javax.media.jai.widget.ScrollingImagePanel;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.io.LineWriter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoverage
extends PropertySourceImpl
implements Coverage {
    private static final long serialVersionUID = -2989320942499746295L;
    private static final int VISIBLE_BAND = 0;
    private final InternationalString name;
    protected final CoordinateReferenceSystem crs;

    protected AbstractCoverage(CharSequence name, CoordinateReferenceSystem crs, PropertySource propertySource, Map<?, ?> properties) {
        super(properties, propertySource);
        this.name = SimpleInternationalString.wrap(name);
        this.crs = crs;
    }

    protected AbstractCoverage(CharSequence name, Coverage coverage) {
        super(null, coverage instanceof PropertySource ? (PropertySource)((Object)coverage) : null);
        AbstractInternationalString n = SimpleInternationalString.wrap(name);
        if (coverage instanceof AbstractCoverage) {
            AbstractCoverage source = (AbstractCoverage)coverage;
            this.name = n != null ? n : source.name;
            this.crs = source.crs;
        } else {
            this.name = n != null ? n : new SimpleInternationalString(coverage.toString());
            this.crs = coverage.getCoordinateReferenceSystem();
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    public final int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public Envelope getEnvelope() {
        return CRS.getEnvelope(this.crs);
    }

    @Override
    public RecordType getRangeType() {
        throw AbstractCoverage.unsupported();
    }

    private static final UnsupportedOperationException unsupported() {
        throw new UnsupportedOperationException("This method is currently not implemented. It may be implemented by next version of coverage module.");
    }

    private static String formatErrorMessage(Object array) {
        Class<?> type = null;
        if (array != null && (type = array.getClass()).isArray()) {
            type = type.getComponentType();
        }
        return Errors.format(22, type);
    }

    @Override
    public Set<Record> evaluate(DirectPosition p, Collection<String> list) {
        throw AbstractCoverage.unsupported();
    }

    @Override
    public boolean[] evaluate(DirectPosition coord, boolean[] dest) throws PointOutsideCoverageException, CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new boolean[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getBoolean(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), exception);
        }
        return dest;
    }

    @Override
    public byte[] evaluate(DirectPosition coord, byte[] dest) throws PointOutsideCoverageException, CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new byte[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getByte(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), exception);
        }
        return dest;
    }

    @Override
    public int[] evaluate(DirectPosition coord, int[] dest) throws PointOutsideCoverageException, CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new int[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getInt(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), exception);
        }
        return dest;
    }

    @Override
    public float[] evaluate(DirectPosition coord, float[] dest) throws PointOutsideCoverageException, CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new float[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getFloat(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), exception);
        }
        return dest;
    }

    @Override
    public double[] evaluate(DirectPosition coord, double[] dest) throws PointOutsideCoverageException, CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new double[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getDouble(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), exception);
        }
        return dest;
    }

    @Override
    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        return new Renderable(xAxis, yAxis);
    }

    public void show(String title, int xAxis, int yAxis) {
        if (title == null || (title = title.trim()).length() == 0) {
            title = String.valueOf(this.getName());
        }
        new Viewer(title, this.getRenderableImage(xAxis, yAxis).createDefaultRendering());
    }

    public void show(String title) {
        this.show(title, 0, 1);
    }

    public void show() {
        this.show(null);
    }

    @Override
    public List<? extends Coverage> getSources() {
        return Collections.emptyList();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        out.write(Classes.getShortClassName(this));
        out.write("[\"");
        out.write(String.valueOf(this.getName()));
        out.write(34);
        Envelope envelope = this.getEnvelope();
        if (envelope != null) {
            out.write(", ");
            out.write(envelope.toString());
        }
        if (this.crs != null) {
            out.write(", ");
            out.write(Classes.getShortClassName(this.crs));
            out.write("[\"");
            out.write(this.crs.getName().getCode());
            out.write("\"]");
        }
        out.write(93);
        String lineSeparator = System.getProperty("line.separator", "\n");
        LineWriter filter = new LineWriter(out, lineSeparator + "\u2502   ");
        int n = this.getNumSampleDimensions();
        try {
            filter.write(lineSeparator);
            for (int i = 0; i < n; ++i) {
                filter.write(this.getSampleDimension(i).toString());
            }
            filter.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        StringBuffer buffer = out.getBuffer();
        buffer.setLength(buffer.lastIndexOf(lineSeparator) + lineSeparator.length());
        return buffer.toString();
    }

    public boolean dispose(boolean force) {
        return true;
    }

    private static final class Viewer
    extends WindowAdapter
    implements Runnable {
        private final Frame frame;

        public Viewer(String title, RenderedImage image) {
            int width = Math.max(Math.min(image.getWidth(), 800), 24);
            int height = Math.max(Math.min(image.getHeight(), 600), 24);
            this.frame = new Frame(title);
            this.frame.add(new ScrollingImagePanel(image, width, height));
            this.frame.addWindowListener(this);
            EventQueue.invokeLater(this);
        }

        public void run() {
            this.frame.pack();
            this.frame.setVisible(true);
        }

        public void windowClosing(WindowEvent e) {
            this.frame.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Renderable
    extends PropertySourceImpl
    implements RenderableImage,
    ImageFunction {
        private static final long serialVersionUID = -6661389795161502552L;
        private final Rectangle2D bounds;
        protected final int xAxis;
        protected final int yAxis;
        protected final GeneralDirectPosition coordinate;

        public Renderable(int xAxis, int yAxis) {
            super(null, AbstractCoverage.this);
            this.coordinate = new GeneralDirectPosition(AbstractCoverage.this.getDimension());
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            Envelope envelope = AbstractCoverage.this.getEnvelope();
            this.bounds = new Rectangle2D.Double(envelope.getMinimum(xAxis), envelope.getMinimum(yAxis), envelope.getSpan(xAxis), envelope.getSpan(yAxis));
        }

        @Override
        public Vector<RenderableImage> getSources() {
            return null;
        }

        @Override
        public boolean isDynamic() {
            return false;
        }

        @Override
        public boolean isComplex() {
            return false;
        }

        @Override
        public float getWidth() {
            return (float)this.bounds.getWidth();
        }

        @Override
        public float getHeight() {
            return (float)this.bounds.getHeight();
        }

        @Override
        public float getMinX() {
            return (float)this.bounds.getX();
        }

        @Override
        public float getMinY() {
            return (float)this.bounds.getY();
        }

        @Override
        public RenderedImage createDefaultRendering() {
            return this.createScaledRendering(512, 0, null);
        }

        @Override
        public RenderedImage createScaledRendering(int width, int height, RenderingHints hints) {
            double boundsWidth = this.bounds.getWidth();
            double boundsHeight = this.bounds.getHeight();
            if (width <= 0) {
                if (height <= 0) {
                    throw new IllegalArgumentException(Errors.format(194));
                }
                width = (int)Math.round((double)height * (boundsWidth / boundsHeight));
            } else if (height <= 0) {
                height = (int)Math.round((double)width * (boundsHeight / boundsWidth));
            }
            return this.createRendering(this.createRenderContext(new Rectangle(0, 0, width, height), hints));
        }

        @Override
        public RenderedImage createRendering(RenderContext context) {
            PlanarImage image;
            AffineTransform crsToGrid = context.getTransform();
            Shape area = context.getAreaOfInterest();
            Rectangle2D bounds = XAffineTransform.transform(crsToGrid, area != null ? area.getBounds2D() : this.bounds, null);
            int xmin = (int)Math.round(bounds.getMinX());
            int ymin = (int)Math.round(bounds.getMinY());
            int xmax = (int)Math.round(bounds.getMaxX());
            int ymax = (int)Math.round(bounds.getMaxY());
            Rectangle gridBounds = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            Dimension tileSize = ImageUtilities.toTileSize(gridBounds.getSize());
            GridSampleDimension band = GridSampleDimension.wrap(AbstractCoverage.this.getSampleDimension(0));
            ColorModel colorModel = band.getColorModel(0, AbstractCoverage.this.getNumSampleDimensions());
            SampleModel sampleModel = colorModel.createCompatibleSampleModel(tileSize.width, tileSize.height);
            if ((area == null || area instanceof Rectangle2D) && crsToGrid.getShearX() == 0.0 && crsToGrid.getShearY() == 0.0) {
                image = ImageFunctionDescriptor.create(this, gridBounds.width, gridBounds.height, Float.valueOf((float)(1.0 / crsToGrid.getScaleX())), Float.valueOf((float)(1.0 / crsToGrid.getScaleY())), Float.valueOf((float)crsToGrid.getTranslateX()), Float.valueOf((float)crsToGrid.getTranslateY()), new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout().setMinX(gridBounds.x).setMinY(gridBounds.y).setTileWidth(tileSize.width).setTileHeight(tileSize.height).setSampleModel(sampleModel).setColorModel(colorModel)));
            } else {
                GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
                TiledImage tiled = new TiledImage(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height, 0, 0, sampleModel, colorModel);
                Point2D.Double point2D = new Point2D.Double();
                int numBands = tiled.getNumBands();
                double[] samples = new double[numBands];
                double[] padNaNs = new double[numBands];
                Arrays.fill(padNaNs, Double.NaN);
                WritableRectIter iterator = RectIterFactory.createWritable(tiled, gridBounds);
                if (!iterator.finishedLines()) {
                    try {
                        int y = gridBounds.y;
                        do {
                            iterator.startPixels();
                            if (iterator.finishedPixels()) continue;
                            int x = gridBounds.x;
                            do {
                                point2D.x = x;
                                point2D.y = y;
                                crsToGrid.inverseTransform(point2D, point2D);
                                if (area == null || area.contains(point2D)) {
                                    coordinate.ordinates[this.xAxis] = point2D.x;
                                    coordinate.ordinates[this.yAxis] = point2D.y;
                                    iterator.setPixel(AbstractCoverage.this.evaluate((DirectPosition)coordinate, samples));
                                } else {
                                    iterator.setPixel(padNaNs);
                                }
                                ++x;
                            } while (!iterator.nextPixelDone());
                            assert (x == gridBounds.x + gridBounds.width);
                            ++y;
                        } while (!iterator.nextLineDone());
                        assert (y == gridBounds.y + gridBounds.height);
                    }
                    catch (NoninvertibleTransformException exception) {
                        throw new IllegalArgumentException(Errors.format(57, "context"), exception);
                    }
                }
                image = tiled;
            }
            try {
                image.setProperty("gridToCRS", crsToGrid.createInverse());
            }
            catch (NoninvertibleTransformException exception) {
                Logging.unexpectedException(Renderable.class, "createRendering", exception);
            }
            return image;
        }

        protected RenderContext createRenderContext(Rectangle2D gridBounds, RenderingHints hints) {
            GeneralMatrix matrix;
            GeneralEnvelope srcEnvelope = new GeneralEnvelope(this.bounds);
            GeneralEnvelope dstEnvelope = new GeneralEnvelope(gridBounds);
            if (AbstractCoverage.this.crs != null) {
                CoordinateSystem cs = AbstractCoverage.this.crs.getCoordinateSystem();
                AxisDirection[] axis = new AxisDirection[]{cs.getAxis(this.xAxis).getDirection(), cs.getAxis(this.yAxis).getDirection()};
                AxisDirection[] normalized = (AxisDirection[])axis.clone();
                normalized[1] = normalized[1].opposite();
                matrix = new GeneralMatrix(srcEnvelope, axis, dstEnvelope, normalized);
            } else {
                matrix = new GeneralMatrix(srcEnvelope, dstEnvelope);
            }
            return new RenderContext(matrix.toAffineTransform2D(), hints);
        }

        @Override
        public int getNumElements() {
            return AbstractCoverage.this.getNumSampleDimensions();
        }

        @Override
        public void getElements(float startX, float startY, float deltaX, float deltaY, int countX, int countY, int element, float[] real, float[] imag) {
            int index = 0;
            float[] buffer = null;
            GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
            coordinate.ordinates[1] = startY;
            for (int j = 0; j < countY; ++j) {
                coordinate.ordinates[0] = startX;
                for (int i = 0; i < countX; ++i) {
                    buffer = AbstractCoverage.this.evaluate((DirectPosition)coordinate, buffer);
                    real[index++] = buffer[element];
                    coordinate.ordinates[0] = coordinate.ordinates[0] + (double)deltaX;
                }
                coordinate.ordinates[1] = coordinate.ordinates[1] + (double)deltaY;
            }
        }

        @Override
        public void getElements(double startX, double startY, double deltaX, double deltaY, int countX, int countY, int element, double[] real, double[] imag) {
            int index = 0;
            double[] buffer = null;
            GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
            coordinate.ordinates[1] = startY;
            for (int j = 0; j < countY; ++j) {
                coordinate.ordinates[0] = startX;
                for (int i = 0; i < countX; ++i) {
                    buffer = AbstractCoverage.this.evaluate((DirectPosition)coordinate, buffer);
                    real[index++] = buffer[element];
                    coordinate.ordinates[0] = coordinate.ordinates[0] + deltaX;
                }
                coordinate.ordinates[1] = coordinate.ordinates[1] + deltaY;
            }
        }
    }
}

