/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.avhrr.HeaderUtil;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

abstract class AsciiRecord {
    private Map<String, String> map;
    private int fieldCount;

    public AsciiRecord(int fieldCount) {
        this.fieldCount = fieldCount;
        this.map = new HashMap<String, String>();
    }

    public void readRecord(ImageInputStream imageInputStream) throws IOException {
        int i = 0;
        while (i < this.fieldCount) {
            String fieldString = imageInputStream.readLine();
            KeyValuePair field = new KeyValuePair(fieldString);
            this.map.put(field.key, field.value);
            ++i;
        }
    }

    public String getValue(String key) {
        return this.map.get(key);
    }

    public int getIntValue(String key) {
        return Integer.parseInt(this.getValue(key));
    }

    public long getLongValue(String key) {
        return Long.parseLong(this.getValue(key));
    }

    public abstract MetadataElement getMetaData();

    public void printValues() {
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            System.out.println(String.valueOf(key) + "=" + this.map.get(key));
        }
    }

    MetadataAttribute createStringAttribute(String key, String unit) {
        String stringValue = this.getValue(key);
        if (stringValue != null) {
            return HeaderUtil.createAttribute(key, stringValue, unit);
        }
        return null;
    }

    MetadataAttribute createFloatAttribute(String key, float scalingFactor, String unit) {
        String stringValue = this.getValue(key);
        if (stringValue != null) {
            try {
                long longValue = Long.parseLong(stringValue);
                return HeaderUtil.createAttribute(key, (float)longValue * scalingFactor, unit);
            }
            catch (NumberFormatException numberFormatException) {
                return HeaderUtil.createAttribute(key, stringValue, unit);
            }
        }
        return null;
    }

    MetadataAttribute createIntAttribute(String key, String unit) {
        String stringValue = this.getValue(key);
        if (stringValue != null) {
            try {
                int intValue = Integer.parseInt(stringValue);
                return HeaderUtil.createAttribute(key, intValue, unit);
            }
            catch (NumberFormatException numberFormatException) {
                return HeaderUtil.createAttribute(key, stringValue, unit);
            }
        }
        return null;
    }

    MetadataAttribute createDateAttribute(String key, DateFormat dateFormat) {
        MetadataAttribute attribute;
        String dateString = this.getValue(key);
        try {
            Date date = dateFormat.parse(dateString);
            ProductData.UTC utc = ProductData.UTC.create(date, 0L);
            attribute = new MetadataAttribute(key, utc, true);
        }
        catch (ParseException parseException) {
            ProductData data = ProductData.createInstance(dateString);
            attribute = new MetadataAttribute(key, data, true);
        }
        attribute.setUnit("date");
        return attribute;
    }

    private class KeyValuePair {
        final String key;
        final String value;

        public KeyValuePair(String field) {
            this.key = field.substring(0, 30).trim();
            this.value = field.substring(32).trim();
        }
    }
}

