/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import Jama.Matrix;
import org.esa.beam.util.math.ConstrainedLSU;
import org.esa.beam.util.math.LinearAlgebra;
import org.esa.beam.util.math.SpectralUnmixing;

public class FullyConstrainedLSU
implements SpectralUnmixing {
    private final int nchem;
    private final int nmemb;
    private final SpectralUnmixing[][] trialModels;
    private final boolean[][][] sortedemcombs;

    public FullyConstrainedLSU(double[][] endmembers) {
        int p;
        int nc;
        if (!LinearAlgebra.isMatrix(endmembers)) {
            throw new IllegalArgumentException("Parameter 'endmembers' is not a matrix.");
        }
        this.nchem = endmembers.length;
        this.nmemb = endmembers[0].length;
        int nposs = (1 << this.nmemb) - 1;
        int[] rb = new int[nposs];
        int i = 0;
        while (i < nposs) {
            rb[i] = i + 1;
            ++i;
        }
        boolean[][] emcombs = new boolean[nposs][this.nmemb];
        int k = 0;
        while (k < nposs) {
            int zpot = 1;
            int l = 0;
            while (l < this.nmemb) {
                int h = zpot & rb[k];
                emcombs[k][l] = h > 0;
                zpot *= 2;
                ++l;
            }
            ++k;
        }
        int[] numbin = new int[nposs];
        int k2 = 0;
        while (k2 < nposs) {
            numbin[k2] = FullyConstrainedLSU.countTrue(emcombs[k2]);
            ++k2;
        }
        this.sortedemcombs = new boolean[this.nmemb][][];
        this.trialModels = new ConstrainedLSU[this.nmemb][];
        int nem = this.nmemb - 1;
        while (nem >= 0) {
            nc = 0;
            p = 0;
            while (p < nposs) {
                if (nem + 1 == numbin[p]) {
                    ++nc;
                }
                ++p;
            }
            this.sortedemcombs[this.nmemb - nem - 1] = new boolean[nc][this.nmemb];
            this.trialModels[this.nmemb - nem - 1] = new ConstrainedLSU[nc];
            --nem;
        }
        nem = this.nmemb - 1;
        while (nem >= 0) {
            nc = 0;
            p = 0;
            while (p < nposs) {
                if (nem + 1 == numbin[p]) {
                    System.arraycopy(emcombs[p], 0, this.sortedemcombs[this.nmemb - nem - 1][nc], 0, this.nmemb);
                    double[][] trem = FullyConstrainedLSU.extractColumns(endmembers, this.sortedemcombs[this.nmemb - nem - 1][nc]);
                    this.trialModels[this.nmemb - nem - 1][nc] = new ConstrainedLSU(trem);
                    ++nc;
                }
                ++p;
            }
            --nem;
        }
    }

    @Override
    public double[][] unmix(double[][] spectra) {
        int colCount = spectra[0].length;
        Matrix res = new Matrix(this.nmemb, colCount);
        int nspek = 0;
        while (nspek < colCount) {
            double[][] singlesp = FullyConstrainedLSU.extractSingleColum(spectra, nspek);
            double totalerrbest = 1.0E21;
            int nc = 0;
            while (nc < this.nmemb) {
                boolean foundlegal = false;
                int nmods = this.trialModels[nc].length;
                boolean[] allabupos = new boolean[nmods];
                double[][][] abuc = new double[nmods][][];
                int m = 0;
                while (m < nmods) {
                    allabupos[m] = true;
                    ++m;
                }
                double[] err = new double[nmods];
                int m2 = 0;
                while (m2 < nmods) {
                    abuc[m2] = this.trialModels[nc][m2].unmix(singlesp);
                    int k = 0;
                    while (k < abuc[m2].length) {
                        if (abuc[m2][k][0] < 0.0) {
                            allabupos[m2] = false;
                        }
                        ++k;
                    }
                    if (allabupos[m2]) {
                        foundlegal = true;
                        double[][] rspek = this.trialModels[nc][m2].mix(abuc[m2]);
                        double sum = 0.0;
                        int k2 = 0;
                        while (k2 < this.nchem) {
                            double diff = singlesp[k2][0] - rspek[k2][0];
                            sum += diff * diff;
                            ++k2;
                        }
                        err[m2] = sum;
                    }
                    ++m2;
                }
                if (foundlegal) {
                    int mbest = -1;
                    double errbest = Double.POSITIVE_INFINITY;
                    int m3 = 0;
                    while (m3 < nmods) {
                        if (allabupos[m3] && err[m3] < errbest) {
                            errbest = err[m3];
                            mbest = m3;
                        }
                        ++m3;
                    }
                    if (mbest != -1) {
                        double[][] abucd = abuc[mbest];
                        double[][] abu = new double[this.nmemb][1];
                        int take = 0;
                        int k = 0;
                        while (k < this.nmemb) {
                            if (this.sortedemcombs[nc][mbest][k]) {
                                abu[k][0] = abucd[take][0];
                                ++take;
                            }
                            ++k;
                        }
                        if (errbest < totalerrbest) {
                            res.setMatrix(0, this.nmemb - 1, nspek, nspek, new Matrix(abu));
                            totalerrbest = errbest;
                        }
                    }
                }
                ++nc;
            }
            ++nspek;
        }
        return res.getArrayCopy();
    }

    @Override
    public double[][] mix(double[][] abundances) {
        return this.trialModels[0][0].mix(abundances);
    }

    private static double[][] extractColumns(double[][] a, boolean[] columns) {
        int rowCount = a.length;
        int colCount = a[0].length;
        int hm = 0;
        boolean[] blArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            boolean column = blArray[n2];
            if (column) {
                ++hm;
            }
            ++n2;
        }
        double[][] c = new double[rowCount][hm];
        int j = 0;
        int k = 0;
        while (j < colCount) {
            if (columns[j]) {
                int i = 0;
                while (i < rowCount) {
                    c[i][k] = a[i][j];
                    ++i;
                }
                ++k;
            }
            ++j;
        }
        return c;
    }

    private static double[][] extractSingleColum(double[][] a, int j) {
        double[][] c = new double[a.length][1];
        int i = 0;
        while (i < a.length) {
            c[i][0] = a[i][j];
            ++i;
        }
        return c;
    }

    private static int countTrue(boolean[] combs) {
        int count = 0;
        boolean[] blArray = combs;
        int n = combs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean comb = blArray[n2];
            if (comb) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

