/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import java.io.File;
import java.lang.reflect.Constructor;
import javax.swing.JFileChooser;
import org.esa.beam.util.io.BeamFileChooser;

public class FileChooserFactory {
    private Class<? extends JFileChooser> fileChooserClass = BeamFileChooser.class;
    private Class<? extends JFileChooser> dirChooserClass = BeamFileChooser.class;

    public Class<? extends JFileChooser> getFileChooserClass() {
        return this.fileChooserClass;
    }

    public void setFileChooserClass(Class<? extends JFileChooser> fileChooserClass) {
        this.fileChooserClass = fileChooserClass;
    }

    public Class<? extends JFileChooser> getDirChooserClass() {
        return this.dirChooserClass;
    }

    public void setDirChooserClass(Class<? extends JFileChooser> dirChooserClass) {
        this.dirChooserClass = dirChooserClass;
    }

    public static FileChooserFactory getInstance() {
        return Holder.instance;
    }

    public JFileChooser createFileChooser(File currentDirectory) {
        JFileChooser fileChooser = this.createChooser(this.fileChooserClass, currentDirectory);
        fileChooser.setFileSelectionMode(2);
        return fileChooser;
    }

    public JFileChooser createDirChooser(File currentDirectory) {
        JFileChooser dirChooser = this.createChooser(this.dirChooserClass, currentDirectory);
        dirChooser.setFileSelectionMode(1);
        return dirChooser;
    }

    private JFileChooser createChooser(Class<?> chooserClass, File currentDirectory) {
        JFileChooser fileChooser;
        try {
            Constructor<?> constructor = chooserClass.getConstructor(File.class);
            fileChooser = (JFileChooser)constructor.newInstance(currentDirectory);
        }
        catch (Throwable throwable) {
            fileChooser = new JFileChooser(currentDirectory);
        }
        return fileChooser;
    }

    private FileChooserFactory() {
    }

    /* synthetic */ FileChooserFactory(FileChooserFactory fileChooserFactory) {
        this();
    }

    private static class Holder {
        private static final FileChooserFactory instance = new FileChooserFactory(null);

        private Holder() {
        }
    }
}

