/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductIOPlugIn;
import org.esa.beam.util.StringUtils;

public class BeamFileFilter
extends FileFilter {
    private String formatName;
    private String[] extensions;
    private String description;

    public BeamFileFilter() {
    }

    public BeamFileFilter(String formatName, String extension, String description) {
        this(formatName, StringUtils.toStringArray(extension, ","), description);
    }

    public BeamFileFilter(String formatName, String[] extensions, String description) {
        this.setFormatName(formatName);
        this.setExtensions(extensions);
        this.setDescription(description);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.length > 0;
    }

    public String getDefaultExtension() {
        return this.hasExtensions() ? this.getExtensions()[0] : null;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        if (extensions != null) {
            ArrayList<String> extensionList = new ArrayList<String>();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (extension.startsWith(".")) {
                    extensionList.add(extension);
                } else if (extension.trim().length() > 0) {
                    extensionList.add("." + extension);
                }
                ++n2;
            }
            this.extensions = extensionList.toArray(new String[extensionList.size()]);
        } else {
            this.extensions = null;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.hasExtensions() && !description.endsWith(")")) {
            StringBuilder sb = new StringBuilder(description);
            sb.append(" (");
            int i = 0;
            while (i < this.extensions.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("*");
                if (this.extensions[i] != null) {
                    sb.append(this.extensions[i]);
                }
                ++i;
            }
            sb.append(")");
            this.description = sb.toString();
        } else {
            this.description = description;
        }
    }

    public boolean checkExtension(File file) {
        return file != null && this.checkExtension(file.getName());
    }

    public boolean checkExtension(String filename) {
        return BeamFileFilter.checkExtensions(filename, this.extensions);
    }

    public static boolean checkExtensions(String filename, String[] extensions) {
        if (filename != null) {
            filename = filename.toLowerCase();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (filename.endsWith(extension = extension.toLowerCase())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (!this.hasExtensions()) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        return this.checkExtension(file);
    }

    public boolean isCompoundDocument(File dir) {
        return false;
    }

    public FileSelectionMode getFileSelectionMode() {
        return FileSelectionMode.FILES_ONLY;
    }

    public static <T extends ProductIOPlugIn> List<BeamFileFilter> getSortedFileFilters(Iterator<T> pluginIterator) {
        ArrayList<BeamFileFilter> fileFilterList = new ArrayList<BeamFileFilter>();
        while (pluginIterator.hasNext()) {
            BeamFileFilter productFileFilter = ((ProductIOPlugIn)pluginIterator.next()).getProductFileFilter();
            if (productFileFilter == null) continue;
            fileFilterList.add(productFileFilter);
        }
        Collections.sort(fileFilterList, new Comparator<BeamFileFilter>(){

            @Override
            public int compare(BeamFileFilter bff1, BeamFileFilter bff2) {
                return bff1.getDescription().compareTo(bff2.getDescription());
            }
        });
        return fileFilterList;
    }

    public static enum FileSelectionMode {
        FILES_ONLY(0),
        DIRECTORIES_ONLY(1),
        FILES_AND_DIRECTORIES(2);

        private final int value;

        private FileSelectionMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

