/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.geotiff;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class IIOUtils {
    public static IIOImage readImage(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        if (!input.canRead()) {
            throw new IIOException("Can't readImage input file!");
        }
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        if (stream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        return IIOUtils.readImage(stream);
    }

    public static IIOImage readImage(ImageInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        IIOImage iioImage = reader.readAll(0, param);
        stream.close();
        reader.dispose();
        return iioImage;
    }

    public static boolean writeImage(IIOImage iioImage, String formatName, File output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream stream = null;
        try {
            output.delete();
            stream = ImageIO.createImageOutputStream(output);
        }
        catch (IOException e) {
            throw new IIOException("Can't create output stream!", e);
        }
        boolean val = IIOUtils.writeImage(iioImage, formatName, stream);
        stream.close();
        return val;
    }

    public static boolean writeImage(IIOImage iioImage, String formatName, ImageOutputStream output) throws IOException {
        if (iioImage == null) {
            throw new IllegalArgumentException("iioImage == null!");
        }
        if (formatName == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(iioImage.getRenderedImage());
        ImageWriter writer = IIOUtils.getImageWriter(type, formatName);
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        writer.write(iioImage);
        output.flush();
        writer.dispose();
        return true;
    }

    public static ImageWriter getImageWriter(ImageTypeSpecifier imageType, String imageFormatName) {
        return IIOUtils.getImageWriter(imageType, imageFormatName, null);
    }

    public static ImageWriter getImageWriter(ImageTypeSpecifier imageType, String imageFormatName, String metadataFormatName) {
        ImageWriter writer;
        Iterator<ImageWriter> writers = ImageIO.getImageWriters(imageType, imageFormatName);
        while (writers.hasNext()) {
            writer = writers.next();
            if (metadataFormatName == null) {
                return writer;
            }
            String nativeImageMetadataFormatName = writer.getOriginatingProvider().getNativeImageMetadataFormatName();
            if (!metadataFormatName.equals(nativeImageMetadataFormatName)) continue;
            return writer;
        }
        writers = ImageIO.getImageWriters(imageType, imageFormatName);
        while (writers.hasNext()) {
            writer = writers.next();
            String[] extraImageMetadataFormatNames = writer.getOriginatingProvider().getExtraImageMetadataFormatNames();
            int i = 0;
            while (i < extraImageMetadataFormatNames.length) {
                String extraImageMetadataFormatName = extraImageMetadataFormatNames[i];
                if (metadataFormatName.equals(extraImageMetadataFormatName)) {
                    return writer;
                }
                ++i;
            }
        }
        return null;
    }

    public static String getXML(IIOMetadata metadata) {
        String metadataFormatName = metadata.getNativeMetadataFormatName();
        return IIOUtils.getXML((org.w3c.dom.Element)metadata.getAsTree(metadataFormatName));
    }

    private static String getXML(org.w3c.dom.Element metadataElement) {
        return IIOUtils.getXML(IIOUtils.convertToJDOM(metadataElement));
    }

    private static String getXML(Element metadataElement) {
        Format prettyFormat = Format.getPrettyFormat();
        prettyFormat.setExpandEmptyElements(false);
        prettyFormat.setOmitEncoding(true);
        prettyFormat.setOmitDeclaration(true);
        prettyFormat.setTextMode(Format.TextMode.PRESERVE);
        XMLOutputter xmlOutputter = new XMLOutputter(prettyFormat);
        String xml = xmlOutputter.outputString(metadataElement);
        return xml;
    }

    private static Element convertToJDOM(org.w3c.dom.Element metadataElement) {
        return new DOMBuilder().build(metadataElement);
    }

    private IIOUtils() {
    }
}

