/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import org.esa.beam.util.Debug;

public class StopWatch {
    static final int MILLIS_PER_SECOND = 1000;
    static final int MILLIS_PER_MINUTE = 60000;
    static final int MILLIS_PER_HOUR = 3600000;
    private long _startTime;
    private long _endTime;

    public StopWatch() {
        this.start();
    }

    public void start() {
        this._startTime = this._endTime = System.currentTimeMillis();
    }

    public void stop() {
        this._endTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public long getTimeDiff() {
        return this._endTime - this._startTime;
    }

    public String getTimeDiffString() {
        return StopWatch.getTimeString(this.getTimeDiff());
    }

    public static String getTimeString(long millis) {
        long hours = millis / 3600000L;
        long minutes = (millis -= hours * 3600000L) / 60000L;
        long seconds = (millis -= minutes * 60000L) / 1000L;
        millis -= seconds * 1000L;
        StringBuffer sb = new StringBuffer();
        if (hours < 10L) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
        sb.append('.');
        if (millis < 100L) {
            sb.append('0');
        }
        if (millis < 10L) {
            sb.append('0');
        }
        sb.append(millis);
        return sb.toString();
    }

    public String toString() {
        return this.getTimeDiffString();
    }

    public void stopAndTrace(String label) {
        this.stop();
        this.trace(label);
    }

    public void trace(String label) {
        if (Debug.isEnabled()) {
            Debug.trace(String.valueOf(label) + ": " + this.getTimeDiffString());
        }
    }
}

