/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;

public class PlacemarkMaskOpImage
extends SingleBandedOpImage {
    private static final byte FALSE = 0;
    private static final byte TRUE = -1;
    private final ColorModel colorModel;
    private final Product product;
    private final PlacemarkDescriptor placemarkDescriptor;
    private final int placemarkSize;

    public PlacemarkMaskOpImage(Product product, PlacemarkDescriptor placemarkDescriptor, int placemarkSize, int width, int height, ResolutionLevel level) {
        super(0, width, height, product.getPreferredTileSize(), null, level);
        this.product = product;
        this.placemarkDescriptor = placemarkDescriptor;
        this.placemarkSize = placemarkSize;
        this.colorModel = PlacemarkMaskOpImage.createColorModel(this.getSampleModel());
    }

    @Override
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        Placemark[] placemarks;
        BufferedImage image = new BufferedImage(this.colorModel, RasterFactory.createWritableRaster(tile.getSampleModel(), tile.getDataBuffer(), new Point(0, 0)), false, null);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.translate(-tile.getMinX(), -tile.getMinY());
        graphics2D.setColor(Color.WHITE);
        ProductNodeGroup<Placemark> placemarkGroup = this.getPlacemarkGroup();
        Placemark[] placemarkArray = placemarks = (Placemark[])placemarkGroup.toArray(new Placemark[placemarkGroup.getNodeCount()]);
        int n = placemarks.length;
        int n2 = 0;
        while (n2 < n) {
            Placemark placemark = placemarkArray[n2];
            PixelPos pixelPos = placemark.getPixelPos();
            if (pixelPos != null) {
                int x = (int)pixelPos.x - this.placemarkSize / 2;
                int y = (int)pixelPos.y - this.placemarkSize / 2;
                graphics2D.fillRect(x, y, this.placemarkSize, this.placemarkSize);
            }
            ++n2;
        }
        graphics2D.dispose();
        byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
        int i = 0;
        while (i < data.length) {
            data[i] = data[i] != 0 ? -1 : 0;
            ++i;
        }
    }

    private ProductNodeGroup<Placemark> getPlacemarkGroup() {
        return this.placemarkDescriptor.getPlacemarkGroup(this.product);
    }
}

