/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import org.esa.beam.framework.datamodel.Graticule;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.glayer.GraticuleLayerType;

public class GraticuleLayer
extends Layer {
    private static final GraticuleLayerType LAYER_TYPE = LayerTypeRegistry.getLayerType(GraticuleLayerType.class);
    private RasterDataNode raster;
    private ProductNodeHandler productNodeHandler;
    private Graticule graticule;

    public GraticuleLayer(RasterDataNode raster) {
        this(LAYER_TYPE, raster, GraticuleLayer.initConfiguration(LAYER_TYPE.createLayerConfig(null), raster));
    }

    public GraticuleLayer(GraticuleLayerType type, RasterDataNode raster, PropertySet configuration) {
        super(type, configuration);
        this.setName("Graticule Layer");
        this.raster = raster;
        this.productNodeHandler = new ProductNodeHandler();
        raster.getProduct().addProductNodeListener(this.productNodeHandler);
        this.setTransparency(0.5);
    }

    private static PropertySet initConfiguration(PropertySet configurationTemplate, RasterDataNode raster) {
        configurationTemplate.setValue("raster", raster);
        return configurationTemplate;
    }

    private Product getProduct() {
        return this.getRaster().getProduct();
    }

    RasterDataNode getRaster() {
        return this.raster;
    }

    @Override
    public void renderLayer(Rendering rendering) {
        if (this.graticule == null) {
            this.graticule = Graticule.create(this.raster, this.getResAuto(), this.getResPixels(), (float)this.getResLat(), (float)this.getResLon());
        }
        if (this.graticule != null) {
            Graphics2D g2d = rendering.getGraphics();
            Viewport vp = rendering.getViewport();
            AffineTransform transformSave = g2d.getTransform();
            try {
                Graticule.TextGlyph[] textGlyphs;
                AffineTransform transform = new AffineTransform();
                transform.concatenate(transformSave);
                transform.concatenate(vp.getModelToViewTransform());
                transform.concatenate(this.raster.getSourceImage().getModel().getImageToModelTransform(0));
                g2d.setTransform(transform);
                GeneralPath[] linePaths = this.graticule.getLinePaths();
                if (linePaths != null) {
                    this.drawLinePaths(g2d, linePaths);
                }
                if (this.isTextEnabled() && (textGlyphs = this.graticule.getTextGlyphs()) != null) {
                    this.drawTextLabels(g2d, textGlyphs);
                }
            }
            finally {
                g2d.setTransform(transformSave);
            }
        }
    }

    private void drawLinePaths(Graphics2D g2d, GeneralPath[] linePaths) {
        Composite oldComposite = null;
        if (this.getLineTransparency() > 0.0) {
            oldComposite = g2d.getComposite();
            g2d.setComposite(this.getAlphaComposite(this.getLineTransparency()));
        }
        g2d.setPaint(this.getLineColor());
        g2d.setStroke(new BasicStroke((float)this.getLineWidth()));
        GeneralPath[] generalPathArray = linePaths;
        int n = linePaths.length;
        int n2 = 0;
        while (n2 < n) {
            GeneralPath linePath = generalPathArray[n2];
            g2d.draw(linePath);
            ++n2;
        }
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    private void drawTextLabels(Graphics2D g2d, Graticule.TextGlyph[] textGlyphs) {
        int n;
        if (this.getTextBgTransparency() < 1.0) {
            Composite oldComposite = null;
            if (this.getTextBgTransparency() > 0.0) {
                oldComposite = g2d.getComposite();
                g2d.setComposite(this.getAlphaComposite(this.getTextBgTransparency()));
            }
            g2d.setPaint(this.getTextBgColor());
            g2d.setStroke(new BasicStroke(0.0f));
            Graticule.TextGlyph[] textGlyphArray = textGlyphs;
            int n2 = textGlyphs.length;
            n = 0;
            while (n < n2) {
                Graticule.TextGlyph glyph = textGlyphArray[n];
                g2d.translate(glyph.getX(), glyph.getY());
                g2d.rotate(glyph.getAngle());
                Rectangle2D labelBounds = g2d.getFontMetrics().getStringBounds(glyph.getText(), g2d);
                labelBounds.setRect(labelBounds.getX() + 3.0 - 1.0, labelBounds.getY() + -3.0 - 1.0, labelBounds.getWidth() + 4.0, labelBounds.getHeight());
                g2d.fill(labelBounds);
                g2d.rotate(-glyph.getAngle());
                g2d.translate(-glyph.getX(), -glyph.getY());
                ++n;
            }
            if (oldComposite != null) {
                g2d.setComposite(oldComposite);
            }
        }
        g2d.setFont(this.getTextFont());
        g2d.setPaint(this.getTextFgColor());
        Graticule.TextGlyph[] textGlyphArray = textGlyphs;
        n = textGlyphs.length;
        int n3 = 0;
        while (n3 < n) {
            Graticule.TextGlyph glyph = textGlyphArray[n3];
            g2d.translate(glyph.getX(), glyph.getY());
            g2d.rotate(glyph.getAngle());
            g2d.drawString(glyph.getText(), 3.0f, -3.0f);
            g2d.rotate(-glyph.getAngle());
            g2d.translate(-glyph.getX(), -glyph.getY());
            ++n3;
        }
    }

    private AlphaComposite getAlphaComposite(double itemTransparancy) {
        double combinedAlpha = (1.0 - this.getTransparency()) * (1.0 - itemTransparancy);
        return AlphaComposite.getInstance(3, (float)combinedAlpha);
    }

    @Override
    public void disposeLayer() {
        Product product = this.getProduct();
        if (product != null) {
            product.removeProductNodeListener(this.productNodeHandler);
            this.graticule = null;
            this.raster = null;
        }
    }

    @Override
    protected void fireLayerPropertyChanged(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("graticule.res.auto") || propertyName.equals("graticule.res.lat") || propertyName.equals("graticule.res.lon") || propertyName.equals("graticule.res.pixels")) {
            this.graticule = null;
        }
        if (this.getConfiguration().getProperty(propertyName) != null) {
            this.getConfiguration().setValue(propertyName, event.getNewValue());
        }
        super.fireLayerPropertyChanged(event);
    }

    private boolean getResAuto() {
        return this.getConfigurationProperty("graticule.res.auto", true);
    }

    private double getResLon() {
        return this.getConfigurationProperty("graticule.res.lon", 1.0);
    }

    private double getResLat() {
        return this.getConfigurationProperty("graticule.res.lat", 1.0);
    }

    private int getResPixels() {
        return this.getConfigurationProperty("graticule.res.pixels", 128);
    }

    private boolean isTextEnabled() {
        return this.getConfigurationProperty("graticule.text.enabled", true);
    }

    private Color getLineColor() {
        return this.getConfigurationProperty("graticule.line.color", GraticuleLayerType.DEFAULT_LINE_COLOR);
    }

    private double getLineTransparency() {
        return this.getConfigurationProperty("graticule.line.transparency", 0.0);
    }

    private double getLineWidth() {
        return this.getConfigurationProperty("graticule.line.width", 0.5);
    }

    private Font getTextFont() {
        return this.getConfigurationProperty("graticule.text.font", GraticuleLayerType.DEFAULT_TEXT_FONT);
    }

    private Color getTextFgColor() {
        return this.getConfigurationProperty("graticule.text.fg.color", GraticuleLayerType.DEFAULT_TEXT_FG_COLOR);
    }

    private Color getTextBgColor() {
        return this.getConfigurationProperty("graticule.text.bg.color", GraticuleLayerType.DEFAULT_TEXT_BG_COLOR);
    }

    private double getTextBgTransparency() {
        return this.getConfigurationProperty("graticule.text.bg.transparency", 0.7);
    }

    private class ProductNodeHandler
    extends ProductNodeListenerAdapter {
        private ProductNodeHandler() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            if (event.getSourceNode() == GraticuleLayer.this.getProduct() && "geoCoding".equals(event.getPropertyName())) {
                GraticuleLayer.this.graticule = null;
                GraticuleLayer.this.fireLayerDataChanged(GraticuleLayer.this.getModelBounds());
            }
        }
    }
}

