/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.esa.beam.framework.param.AbstractParamEditor;
import org.esa.beam.framework.param.Parameter;

public class ComboBoxEditor
extends AbstractParamEditor {
    private JComboBox _comboBox;

    public ComboBoxEditor(Parameter parameter) {
        super(parameter, true);
    }

    public JComboBox getComboBox() {
        return this._comboBox;
    }

    public JTextComponent getTextComponent() {
        Component component;
        javax.swing.ComboBoxEditor swingComboBoxEditor = this._comboBox.getEditor();
        if (swingComboBoxEditor != null && (component = swingComboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        return null;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.getComboBox();
    }

    @Override
    protected void initUI() {
        this.setDefaultLabelComponent(true);
        this._comboBox = new JComboBox();
        this.nameEditorComponent(this._comboBox);
        if (this.getParameter().getProperties().getDescription() != null) {
            this._comboBox.setToolTipText(this.getParameter().getProperties().getDescription());
        }
        if (this.getParameter().getProperties().getValueSet() != null) {
            this._comboBox.setModel(new DefaultComboBoxModel<String>(this.getParameter().getProperties().getValueSet()));
        }
        this._comboBox.setEnabled(!this.getParameter().getProperties().isReadOnly());
        this._comboBox.setEditable(!this.getParameter().getProperties().isValueSetBound());
        JTextComponent textComp = this.getTextComponent();
        if (textComp != null) {
            textComp.setInputVerifier(this.getDefaultInputVerifier());
        }
        this._comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ComboBoxEditor.this.updateParameter();
            }
        });
        Font font = this._comboBox.getFont();
        if (font != null) {
            this._comboBox.setFont(new Font(font.getName(), 0, font.getSize()));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        JComboBox comboBox = this.getComboBox();
        String text = this.getParameter().getValueAsText();
        JTextComponent textComp = this.getTextComponent();
        if (text != null && !text.equals(textComp.getText())) {
            Object selItem;
            if (textComp != null && !textComp.getText().equals(text)) {
                textComp.setText(text);
            }
            if ((selItem = comboBox.getSelectedItem()) == null || !selItem.equals(text)) {
                comboBox.setSelectedItem(text);
            }
        }
        if (comboBox.isEnabled() != this.isEnabled()) {
            comboBox.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void reconfigureUI() {
        int i;
        JComboBox jComboBox = this.getComboBox();
        ItemListener[] itemListeners = (ItemListener[])jComboBox.getListeners(ItemListener.class);
        ActionListener[] actionListeners = (ActionListener[])jComboBox.getListeners(ActionListener.class);
        int i2 = 0;
        while (i2 < itemListeners.length) {
            jComboBox.removeItemListener(itemListeners[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < actionListeners.length) {
            jComboBox.removeActionListener(actionListeners[i2]);
            ++i2;
        }
        jComboBox.removeAllItems();
        String[] valueSet = this.getParameter().getProperties().getValueSet();
        if (valueSet != null) {
            i = 0;
            while (i < valueSet.length) {
                String value = valueSet[i];
                if (value != null) {
                    jComboBox.addItem(value);
                }
                ++i;
            }
        }
        this.setEnabled(!this.getParameter().getProperties().isReadOnly());
        jComboBox.setEditable(!this.getParameter().getProperties().isValueSetBound());
        jComboBox.setSelectedItem(this.getParameter().getValueAsText());
        i = 0;
        while (i < actionListeners.length) {
            jComboBox.addActionListener(actionListeners[i]);
            ++i;
        }
        i = 0;
        while (i < itemListeners.length) {
            jComboBox.addItemListener(itemListeners[i]);
            ++i;
        }
    }

    private void updateParameter() {
        JTextComponent textComp = this.getTextComponent();
        if (textComp != null && this.getComboBox().isEditable()) {
            this.setParameterValue(textComp);
        } else {
            Object newValue = this.getComboBox().getSelectedItem();
            this.getParameter().setValueAsText(newValue != null ? newValue.toString() : "", this.getExceptionHandler());
        }
    }
}

