/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.resamp;

import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.dataop.resamp.BiCubicInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.Resampling;

final class BiSincInterpolationResampling
implements Resampling {
    private static final double DoublePI = Math.PI * 2;
    private static final int filterLength = 5;
    private static final double halfFilterLength = 2.5;

    BiSincInterpolationResampling() {
    }

    @Override
    public String getName() {
        return "BISINC_INTERPOLATION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(5, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        int j_4;
        int j_3;
        int j_2;
        int j_1;
        int j_0;
        int i_4;
        int i_3;
        int i_2;
        int i_1;
        int i_0;
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        double di = x - ((double)i0 + 0.5);
        double dj = y - ((double)j0 + 0.5);
        index.i0 = i0;
        index.j0 = j0;
        int iMax = width - 1;
        int jMax = height - 1;
        if (di >= 0.0) {
            i_0 = i0 - 2;
            i_1 = i0 - 1;
            i_2 = i0;
            i_3 = i0 + 1;
            i_4 = i0 + 2;
            index.ki[0] = di;
        } else {
            i_0 = i0 - 3;
            i_1 = i0 - 2;
            i_2 = i0 - 1;
            i_3 = i0;
            i_4 = i0 + 1;
            index.ki[0] = di + 1.0;
        }
        index.i[0] = i_0 < 0 ? 0 : (i_0 > iMax ? iMax : i_0);
        index.i[1] = i_1 < 0 ? 0 : (i_1 > iMax ? iMax : i_1);
        index.i[2] = i_2 < 0 ? 0 : (i_2 > iMax ? iMax : i_2);
        index.i[3] = i_3 < 0 ? 0 : (i_3 > iMax ? iMax : i_3);
        index.i[4] = i_4 < 0 ? 0 : (i_4 > iMax ? iMax : i_4);
        if (dj >= 0.0) {
            j_0 = j0 - 2;
            j_1 = j0 - 1;
            j_2 = j0;
            j_3 = j0 + 1;
            j_4 = j0 + 2;
            index.kj[0] = dj;
        } else {
            j_0 = j0 - 3;
            j_1 = j0 - 2;
            j_2 = j0 - 1;
            j_3 = j0;
            j_4 = j0 + 1;
            index.kj[0] = dj + 1.0;
        }
        index.j[0] = j_0 < 0 ? 0 : (j_0 > jMax ? jMax : j_0);
        index.j[1] = j_1 < 0 ? 0 : (j_1 > jMax ? jMax : j_1);
        index.j[2] = j_2 < 0 ? 0 : (j_2 > jMax ? jMax : j_2);
        index.j[3] = j_3 < 0 ? 0 : (j_3 > jMax ? jMax : j_3);
        index.j[4] = j_4 < 0 ? 0 : (j_4 > jMax ? jMax : j_4);
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[5];
        int[] y = new int[5];
        double[][] samples = new double[5][5];
        int i = 0;
        while (i < 5) {
            x[i] = (int)index.i[i];
            y[i] = (int)index.j[i];
            ++i;
        }
        if (!raster.getSamples(x, y, samples)) {
            if (Double.isNaN(samples[2][2])) {
                return samples[2][2];
            }
            BiCubicInterpolationResampling.replaceNaNWithMean(samples);
        }
        double muX = index.ki[0];
        double muY = index.kj[0];
        double f0 = BiSincInterpolationResampling.sinc(muX + 2.0) * BiSincInterpolationResampling.hanning(muX + 2.0);
        double f1 = BiSincInterpolationResampling.sinc(muX + 1.0) * BiSincInterpolationResampling.hanning(muX + 1.0);
        double f2 = BiSincInterpolationResampling.sinc(muX + 0.0) * BiSincInterpolationResampling.hanning(muX + 0.0);
        double f3 = BiSincInterpolationResampling.sinc(muX - 1.0) * BiSincInterpolationResampling.hanning(muX - 1.0);
        double f4 = BiSincInterpolationResampling.sinc(muX - 2.0) * BiSincInterpolationResampling.hanning(muX - 2.0);
        double sum = f0 + f1 + f2 + f3 + f4;
        double tmpV0 = (f0 * samples[0][0] + f1 * samples[0][1] + f2 * samples[0][2] + f3 * samples[0][3] + f4 * samples[0][4]) / sum;
        double tmpV1 = (f0 * samples[1][0] + f1 * samples[1][1] + f2 * samples[1][2] + f3 * samples[1][3] + f4 * samples[1][4]) / sum;
        double tmpV2 = (f0 * samples[2][0] + f1 * samples[2][1] + f2 * samples[2][2] + f3 * samples[2][3] + f4 * samples[2][4]) / sum;
        double tmpV3 = (f0 * samples[3][0] + f1 * samples[3][1] + f2 * samples[3][2] + f3 * samples[3][3] + f4 * samples[3][4]) / sum;
        double tmpV4 = (f0 * samples[4][0] + f1 * samples[4][1] + f2 * samples[4][2] + f3 * samples[4][3] + f4 * samples[4][4]) / sum;
        return BiSincInterpolationResampling.interpolationSinc(tmpV0, tmpV1, tmpV2, tmpV3, tmpV4, muY);
    }

    private static double interpolationSinc(double y0, double y1, double y2, double y3, double y4, double mu) {
        double f0 = BiSincInterpolationResampling.sinc(mu + 2.0) * BiSincInterpolationResampling.hanning(mu + 2.0);
        double f1 = BiSincInterpolationResampling.sinc(mu + 1.0) * BiSincInterpolationResampling.hanning(mu + 1.0);
        double f2 = BiSincInterpolationResampling.sinc(mu + 0.0) * BiSincInterpolationResampling.hanning(mu + 0.0);
        double f3 = BiSincInterpolationResampling.sinc(mu - 1.0) * BiSincInterpolationResampling.hanning(mu - 1.0);
        double f4 = BiSincInterpolationResampling.sinc(mu - 2.0) * BiSincInterpolationResampling.hanning(mu - 2.0);
        double sum = f0 + f1 + f2 + f3 + f4;
        return (f0 * y0 + f1 * y1 + f2 * y2 + f3 * y3 + f4 * y4) / sum;
    }

    private static double sinc(double x) {
        return Double.compare(x, 0.0) == 0 ? 1.0 : FastMath.sin(x * Math.PI) / (x * Math.PI);
    }

    public static double hanning(double x) {
        return x >= -2.5 && x <= 2.5 ? 0.5 * (1.0 + FastMath.cos(Math.PI * 2 * x / 6.0)) : 0.0;
    }

    public String toString() {
        return "BiSinc interpolation resampling";
    }
}

