/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.param.Parameter;

@Deprecated
public class AffineTransformDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Affine";
    public static final String NAME = "Affine";
    public static final String MAP_UNIT = "degree";
    private static final String[] PARAMETER_NAMES = new String[]{"scale_x", "shear_y", "shear_x", "scale_y", "translate_x", "translate_y"};
    private static final double[] PARAMETER_DEFAULT_VALUES = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};

    @Override
    public void registerProjections() {
    }

    @Override
    public String getTypeID() {
        return "Affine";
    }

    @Override
    public String getName() {
        return "Affine";
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[PARAMETER_NAMES.length];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = new Parameter(PARAMETER_NAMES[i], PARAMETER_DEFAULT_VALUES[i]);
            ++i;
        }
        return parameters;
    }

    @Override
    public boolean hasTransformUI() {
        return false;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return null;
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = this.getParameterDefaultValues();
        }
        return new AMT(parameterValues);
    }

    private class AMT
    implements MapTransform {
        private AffineTransform _forward;
        private AffineTransform _inverse;
        private final Point2D.Float _temp = new Point2D.Float();

        private AMT(double[] parameterValues) {
            this._forward = new AffineTransform(parameterValues);
            try {
                this._inverse = this._forward.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return AffineTransformDescriptor.this;
        }

        @Override
        public double[] getParameterValues() {
            double[] values = new double[6];
            this._forward.getMatrix(values);
            return values;
        }

        @Override
        public Point2D forward(GeoPos geoPoint, Point2D mapPoint) {
            if (mapPoint == null) {
                mapPoint = new Point2D.Float();
            }
            this._temp.x = geoPoint.lon;
            this._temp.y = geoPoint.lat;
            this._forward.transform(this._temp, mapPoint);
            return mapPoint;
        }

        @Override
        public GeoPos inverse(Point2D mapPoint, GeoPos geoPoint) {
            if (geoPoint == null) {
                geoPoint = new GeoPos();
            }
            this._inverse.transform(mapPoint, this._temp);
            geoPoint.lon = this._temp.x;
            geoPoint.lat = this._temp.y;
            return geoPoint;
        }

        @Override
        public MapTransform createDeepClone() {
            double[] flatmatrix = new double[6];
            this._forward.getMatrix(flatmatrix);
            return new AMT(flatmatrix);
        }
    }
}

