/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.FormatDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.FillConstantOpImage;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Guardian;

public abstract class FilterBand
extends Band {
    private RasterDataNode source;

    protected FilterBand(String name, int dataType, int width, int height, RasterDataNode source) {
        super(name, dataType, width, height);
        Guardian.assertNotNull("source", source);
        this.source = source;
        this.setOwner(source.getProduct());
        this.setSynthetic(true);
        this.setNoDataValue(Double.NaN);
        this.setNoDataValueUsed(true);
    }

    public RasterDataNode getSource() {
        return this.source;
    }

    @Override
    public void dispose() {
        this.source = null;
        super.dispose();
    }

    @Override
    protected RenderedImage createSourceImage() {
        MultiLevelModel model = ImageManager.getMultiLevelModel(this);
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(model){

            @Override
            protected RenderedImage createImage(int level) {
                ImageManager imageManager = ImageManager.getInstance();
                RenderingHints rh = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance(1));
                PlanarImage geophysicalImage = imageManager.getGeophysicalImage(FilterBand.this.getSource(), level);
                int dataBufferType = FilterBand.this.getDataType() == 31 ? 5 : 4;
                geophysicalImage = FormatDescriptor.create(geophysicalImage, dataBufferType, null);
                PlanarImage validMaskImage = imageManager.getValidMaskImage(FilterBand.this.getSource(), level);
                if (validMaskImage != null) {
                    geophysicalImage = new FillConstantOpImage(geophysicalImage, validMaskImage, Float.valueOf(Float.NaN));
                }
                return FilterBand.this.createSourceLevelImage(geophysicalImage, level, rh);
            }
        };
        return new DefaultMultiLevelImage(multiLevelSource);
    }

    protected abstract RenderedImage createSourceLevelImage(RenderedImage var1, int var2, RenderingHints var3);

    @Override
    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for filtered band");
    }
}

