/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geotiff;

import com.sun.media.jai.codec.TIFFField;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.beam.framework.datamodel.FilterBand;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.geotiff.GeoTIFFMetadata;

public class Utils {
    public static final int PRIVATE_BEAM_TIFF_TAG_NUMBER = 65000;

    public static List<TIFFField> createGeoTIFFFields(GeoTIFFMetadata geoTIFFMetadata) {
        double[] modelTransformation;
        int numModelTiePoints;
        double[] modelPixelScale;
        String geoAsciiString;
        double[] geoDoubleParams;
        ArrayList<TIFFField> list = new ArrayList<TIFFField>(6);
        int numGeoKeyEntries = geoTIFFMetadata.getNumGeoKeyEntries();
        if (numGeoKeyEntries > 0) {
            GeoTIFFMetadata.KeyEntry[] keyEntries = geoTIFFMetadata.getGeoKeyEntries();
            char[] values = new char[keyEntries.length * 4];
            int i = 0;
            while (i < keyEntries.length) {
                int[] data = keyEntries[i].getData();
                int j = 0;
                while (j < data.length) {
                    values[i * 4 + j] = (char)data[j];
                    ++j;
                }
                ++i;
            }
            TIFFField geoKeyDirectory = new TIFFField(34735, 3, values.length, values);
            list.add(geoKeyDirectory);
        }
        if ((geoDoubleParams = geoTIFFMetadata.getGeoDoubleParams()) != null && geoDoubleParams.length > 0) {
            list.add(new TIFFField(34736, 12, geoDoubleParams.length, geoDoubleParams));
        }
        if ((geoAsciiString = geoTIFFMetadata.getGeoAsciiParams()) != null && geoAsciiString.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(geoAsciiString, "|");
            String[] geoAsciiStrings = new String[tokenizer.countTokens()];
            int i = 0;
            while (i < geoAsciiStrings.length) {
                geoAsciiStrings[i] = tokenizer.nextToken().concat("|");
                ++i;
            }
            list.add(new TIFFField(34737, 2, geoAsciiStrings.length, geoAsciiStrings));
        }
        if (Utils.isValidModelPixelScale(modelPixelScale = geoTIFFMetadata.getModelPixelScale())) {
            list.add(new TIFFField(33550, 12, modelPixelScale.length, modelPixelScale));
        }
        if ((numModelTiePoints = geoTIFFMetadata.getNumModelTiePoints()) > 0) {
            double[] tiePointValues = new double[numModelTiePoints * 6];
            int i = 0;
            while (i < numModelTiePoints) {
                GeoTIFFMetadata.TiePoint tiePoint = geoTIFFMetadata.getModelTiePointAt(i);
                double[] data = tiePoint.getData();
                System.arraycopy(data, 0, tiePointValues, i * data.length, data.length);
                ++i;
            }
            list.add(new TIFFField(33922, 12, tiePointValues.length, tiePointValues));
        }
        if (Utils.isValidModelTransformation(modelTransformation = geoTIFFMetadata.getModelTransformation())) {
            list.add(new TIFFField(34264, 12, modelTransformation.length, modelTransformation));
        }
        return list;
    }

    public static boolean isValidModelTransformation(double[] modelTransformation) {
        double[] defaultValues = new double[16];
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    public static boolean isValidModelPixelScale(double[] modelTransformation) {
        double[] defaultValues = new double[]{1.0, 1.0, 0.0};
        return Utils.isValidData(modelTransformation, defaultValues);
    }

    private static boolean isValidData(double[] modelTransformation, double[] defaultValues) {
        if (modelTransformation != null && modelTransformation.length == defaultValues.length) {
            int i = 0;
            while (i < modelTransformation.length) {
                double v = modelTransformation[i];
                double dv = defaultValues[i];
                if (v != dv) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    static String[] findSuitableLatLonNames(Product product) {
        String latName;
        String[] latNames = new String[]{"latitude", "latitude_tpg", "lat", "lat_tpg"};
        String[] lonNames = new String[]{"longitude", "longitude_tpg", "lon", "lon_tpg"};
        String[] names = new String[2];
        int i = 0;
        while (i < latNames.length) {
            latName = latNames[i];
            String lonName = lonNames[i];
            if (!product.containsRasterDataNode(latName) && !product.containsRasterDataNode(lonName)) {
                names[0] = latName;
                names[1] = lonName;
                return names;
            }
            ++i;
        }
        String lonName = String.valueOf(lonNames[0]) + "_";
        latName = String.valueOf(latNames[0]) + "_";
        int index = 1;
        while (product.containsRasterDataNode(String.valueOf(latName) + index) || product.containsRasterDataNode(String.valueOf(lonName) + index)) {
            ++index;
        }
        return new String[]{String.valueOf(latName) + index, String.valueOf(lonName) + index};
    }

    public static boolean shouldWriteNode(ProductNode node) {
        if (node instanceof VirtualBand) {
            return false;
        }
        return !(node instanceof FilterBand);
    }
}

