/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.geometry;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.esa.beam.dataio.geometry.GeometryAndFeatureTypeStrategy;
import org.esa.beam.dataio.geometry.GeometryNoFeatureTypeStrategy;
import org.esa.beam.dataio.geometry.InterpretationStrategy;
import org.esa.beam.dataio.geometry.LatLonAndFeatureTypeStrategy;
import org.esa.beam.dataio.geometry.LatLonNoFeatureTypeStrategy;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PointDescriptor;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.util.FeatureUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.converters.JavaTypeConverter;
import org.esa.beam.util.io.CsvReader;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.data.DataUtilities;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class VectorDataNodeReader {
    private final String sourceName;
    private final Product product;
    private final FeatureUtils.FeatureCrsProvider crsProvider;
    private final PlacemarkDescriptorProvider placemarkDescriptorProvider;
    private final boolean convertToVertices;
    private final CsvReader reader;
    private static final String[] LONGITUDE_IDENTIFIERS = new String[]{"lon", "long", "longitude", "lon_IS"};
    private static final String[] LATITUDE_IDENTIFIERS = new String[]{"lat", "latitude", "lat_IS"};
    private static final String[] GEOMETRY_IDENTIFIERS = new String[]{"geometry", "geom", "the_geom"};
    private Map<String, String> properties;
    private InterpretationStrategy interpretationStrategy;

    private VectorDataNodeReader(String sourceName, Product product, Reader reader, FeatureUtils.FeatureCrsProvider crsProvider, PlacemarkDescriptorProvider placemarkDescriptorProvider, boolean convertToVertices, char delimiterChar) throws IOException {
        this.product = product;
        this.crsProvider = crsProvider;
        this.placemarkDescriptorProvider = placemarkDescriptorProvider;
        this.convertToVertices = convertToVertices;
        this.sourceName = sourceName;
        this.reader = new CsvReader(reader, new char[]{delimiterChar}, true, "#");
    }

    public static VectorDataNode read(String sourceName, Reader reader, Product product, FeatureUtils.FeatureCrsProvider crsProvider, PlacemarkDescriptorProvider placemarkDescriptorProvider, CoordinateReferenceSystem modelCrs, char delimiterChar, ProgressMonitor pm) throws IOException {
        return new VectorDataNodeReader(sourceName, product, reader, crsProvider, placemarkDescriptorProvider, true, delimiterChar).read(modelCrs, pm);
    }

    public static VectorDataNode read(String sourceName, Reader reader, Product product, FeatureUtils.FeatureCrsProvider crsProvider, PlacemarkDescriptorProvider placemarkDescriptorProvider, CoordinateReferenceSystem modelCrs, char delimiterChar, boolean convertToVertices, ProgressMonitor pm) throws IOException {
        return new VectorDataNodeReader(sourceName, product, reader, crsProvider, placemarkDescriptorProvider, convertToVertices, delimiterChar).read(modelCrs, pm);
    }

    VectorDataNode read(CoordinateReferenceSystem modelCrs, ProgressMonitor pm) throws IOException {
        FeatureCollection<SimpleFeatureType, SimpleFeature> clippedCollection;
        String nodeName = FileUtils.getFilenameWithoutExtension(this.sourceName);
        pm.beginTask("Reading vector data node '" + nodeName + "'", 100);
        this.reader.mark(0xA00000);
        this.readProperties();
        pm.worked(5);
        this.interpretationStrategy = this.createInterpretationStrategy();
        pm.worked(5);
        FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = this.readFeatures();
        pm.worked(45);
        if (this.product.getGeoCoding() != null && featureCollection.size() > 0) {
            Geometry clipGeometry = FeatureUtils.createGeoBoundaryPolygon(this.product);
            clippedCollection = FeatureUtils.clipCollection(featureCollection, null, clipGeometry, this.product.getGeoCoding().getGeoCRS(), null, modelCrs, SubProgressMonitor.create(pm, 45));
        } else {
            clippedCollection = featureCollection;
        }
        SimpleFeatureType featureType = clippedCollection.getSchema();
        featureType.getUserData().putAll(this.properties);
        PlacemarkDescriptor placemarkDescriptor = this.placemarkDescriptorProvider.getPlacemarkDescriptor(featureType);
        if (placemarkDescriptor == null) {
            return null;
        }
        placemarkDescriptor.setUserDataOf(featureType);
        if (this.convertToVertices && placemarkDescriptor instanceof PointDescriptor && clippedCollection.size() > 0) {
            clippedCollection = VectorDataNodeReader.convertPointsToVertices(clippedCollection);
        }
        VectorDataNode vectorDataNode = new VectorDataNode(nodeName, clippedCollection, placemarkDescriptor);
        if (this.properties.containsKey("description")) {
            featureType.getUserData().put("description", this.properties.get("description"));
            vectorDataNode.setDescription(this.properties.get("description"));
        }
        if (this.properties.containsKey("defaultCSS")) {
            featureType.getUserData().put("defaultCSS", this.properties.get("defaultCSS"));
            vectorDataNode.setDefaultStyleCss(this.properties.get("defaultCSS"));
        }
        pm.done();
        return vectorDataNode;
    }

    private void readProperties() throws IOException {
        String line;
        this.properties = new OrderRetainingMap();
        while ((line = this.reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) {
                int index = (line = line.substring(1)).indexOf(61);
                if (index != -1) {
                    String name = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (StringUtils.isNotNullAndNotEmpty(name) && StringUtils.isNotNullAndNotEmpty(value)) {
                        this.properties.put(name, value);
                    }
                }
                this.reader.mark(0xA00000);
                continue;
            }
            if (!line.isEmpty()) break;
            this.reader.mark(0xA00000);
        }
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> readFeatures() throws IOException {
        SimpleFeatureType featureType = this.readFeatureType();
        return this.readFeatures(featureType);
    }

    private InterpretationStrategy createInterpretationStrategy() throws IOException {
        boolean hasLatLon;
        this.reader.reset();
        String[] tokens = this.reader.readRecord();
        this.reader.reset();
        if (tokens == null) {
            throw new IOException(String.format("Invalid header in file '%s'", this.sourceName));
        }
        int latIndex = -1;
        int lonIndex = -1;
        int geometryIndex = -1;
        boolean hasFeatureTypeName = false;
        String featureTypeName = null;
        String geometryName = null;
        String defaultGeometry = this.properties.get("defaultGeometry");
        int i = 0;
        while (i < tokens.length) {
            if (i == 0 && tokens[0].startsWith("org.esa.beam")) {
                hasFeatureTypeName = true;
                featureTypeName = tokens[0];
            } else {
                String attributeName;
                String token = tokens[i];
                int colonPos = token.indexOf(58);
                if (colonPos == -1) {
                    attributeName = token;
                } else {
                    if (colonPos == 0) {
                        throw new IOException(String.format("Missing name specifier in attribute descriptor '%s'", token));
                    }
                    attributeName = token.substring(0, colonPos);
                }
                if (defaultGeometry != null && attributeName.equals(defaultGeometry)) {
                    geometryIndex = i;
                    geometryName = attributeName;
                    break;
                }
                if (VectorDataNodeReader.contains(LONGITUDE_IDENTIFIERS, attributeName)) {
                    lonIndex = i;
                } else if (VectorDataNodeReader.contains(LATITUDE_IDENTIFIERS, attributeName)) {
                    latIndex = i;
                } else if (VectorDataNodeReader.contains(GEOMETRY_IDENTIFIERS, attributeName)) {
                    geometryIndex = i;
                    geometryName = attributeName;
                }
            }
            ++i;
        }
        boolean hasGeometry = geometryIndex != -1;
        boolean bl = hasLatLon = latIndex != -1 && lonIndex != -1;
        if (!(hasGeometry || latIndex != -1 && lonIndex != -1)) {
            throw new IOException("Neither lat/lon nor geometry column provided.");
        }
        if (hasGeometry && !hasFeatureTypeName) {
            return new GeometryNoFeatureTypeStrategy(geometryName);
        }
        if (hasGeometry && hasFeatureTypeName) {
            return new GeometryAndFeatureTypeStrategy(geometryName, featureTypeName);
        }
        if (hasLatLon && !hasFeatureTypeName) {
            return new LatLonNoFeatureTypeStrategy(latIndex, lonIndex);
        }
        if (hasLatLon && hasFeatureTypeName) {
            return new LatLonAndFeatureTypeStrategy(featureTypeName, latIndex, lonIndex);
        }
        throw new IllegalStateException("Cannot come here");
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> readFeatures(SimpleFeatureType simpleFeatureType) throws IOException {
        String[] tokens;
        DefaultFeatureCollection fc = new DefaultFeatureCollection("?", simpleFeatureType);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(simpleFeatureType);
        while ((tokens = this.reader.readRecord()) != null) {
            if (!this.isLineValid(simpleFeatureType, tokens)) continue;
            SimpleFeature simpleFeature = null;
            try {
                simpleFeature = this.interpretationStrategy.interpretLine(tokens, builder, simpleFeatureType);
            }
            catch (ConversionException e) {
                BeamLogManager.getSystemLogger().warning(String.format("Unable to parse %s: %s", this.sourceName, e.getMessage()));
            }
            catch (TransformException e) {
                throw new IOException(e);
            }
            if (simpleFeature == null) continue;
            fc.add(simpleFeature);
        }
        return fc;
    }

    private boolean isLineValid(SimpleFeatureType simpleFeatureType, String[] tokens) {
        int expectedTokenCount = this.interpretationStrategy.getExpectedTokenCount(simpleFeatureType.getAttributeCount());
        if (tokens.length != expectedTokenCount) {
            BeamLogManager.getSystemLogger().warning(String.format("Problem in '%s': unexpected number of columns: expected %d, but got %d", this.sourceName, expectedTokenCount, tokens.length));
            return false;
        }
        return true;
    }

    private SimpleFeatureType readFeatureType() throws IOException {
        String[] tokens = this.reader.readRecord();
        if (tokens == null || tokens.length <= 1) {
            throw new IOException("Missing feature type definition in first line.");
        }
        this.reader.mark(0xA00000);
        return this.createFeatureType(tokens);
    }

    private SimpleFeatureType createFeatureType(String[] tokens) throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        CoordinateReferenceSystem featureCrs = this.crsProvider.getFeatureCrs(this.product);
        builder.setCRS(featureCrs);
        JavaTypeConverter jtc = new JavaTypeConverter();
        String[] firstRecord = this.reader.readRecord();
        if (firstRecord != null && firstRecord.length != tokens.length) {
            throw new IOException("First record and header have different column count.");
        }
        this.reader.reset();
        int i = this.interpretationStrategy.getStartColumn();
        while (i < tokens.length) {
            String attributeTypeName;
            String attributeName;
            String token = tokens[i];
            int colonPos = token.indexOf(58);
            if (colonPos == 0) {
                throw new IOException(String.format("Missing name specifier in attribute descriptor '%s'", token));
            }
            if (colonPos == -1) {
                attributeName = token;
                attributeTypeName = this.findAttributeTypeName(firstRecord == null ? "" : firstRecord[i]);
            } else {
                attributeTypeName = token.substring(colonPos + 1);
                attributeName = token.substring(0, colonPos);
            }
            Class<?> attributeType = this.getAttributeType(jtc, token, attributeTypeName);
            builder.add(attributeName, attributeType);
            ++i;
        }
        this.interpretationStrategy.setDefaultGeometry(this.properties.get("defaultGeometry"), featureCrs, builder);
        this.interpretationStrategy.setName(builder);
        return builder.buildFeatureType();
    }

    private String findAttributeTypeName(String entry) throws IOException {
        try {
            Double.parseDouble(entry);
            return "Double";
        }
        catch (NumberFormatException numberFormatException) {
            return "String";
        }
    }

    private Class<?> getAttributeType(JavaTypeConverter jtc, String token, String attributeTypeName) throws IOException {
        Class attributeType;
        try {
            attributeType = jtc.parse(attributeTypeName);
        }
        catch (ConversionException e) {
            throw new IOException(String.format("Unknown type in attribute descriptor '%s'", token), e);
        }
        return attributeType;
    }

    private static boolean contains(String[] possibleStrings, String s) {
        String[] stringArray = possibleStrings;
        int n = possibleStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleString = stringArray[n2];
            if (possibleString.toLowerCase().equals(s.toLowerCase())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static FeatureCollection<SimpleFeatureType, SimpleFeature> convertPointsToVertices(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        FeatureIterator<SimpleFeature> featureIterator = featureCollection.features();
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = featureIterator.next();
            Point pt = (Point)feature.getDefaultGeometry();
            coordList.add(pt.getCoordinate());
        }
        if (coordList.size() >= 2) {
            SimpleFeature feature;
            SimpleFeatureType featureType;
            GeometryFactory geometryFactory = new GeometryFactory();
            try {
                if (VectorDataNodeReader.isClosedPolygon(coordList)) {
                    featureType = DataUtilities.createType("Geometry", "geometry:Polygon");
                    SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                    feature = featureBuilder.buildFeature(Integer.toString(coordList.size() + 1));
                    LinearRing polygon = geometryFactory.createLinearRing(coordList.toArray(new Coordinate[coordList.size()]));
                    feature.setDefaultGeometry(polygon);
                } else {
                    featureType = DataUtilities.createType("Geometry", "geometry:LineString");
                    SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                    feature = featureBuilder.buildFeature(Integer.toString(coordList.size() + 1));
                    LineString lineString = geometryFactory.createLineString(coordList.toArray(new Coordinate[coordList.size()]));
                    feature.setDefaultGeometry(lineString);
                }
            }
            catch (SchemaException e) {
                BeamLogManager.getSystemLogger().warning("Cannot create line/polygon geometry: " + e.getMessage() + " --> Will interpret points as they are.");
                return featureCollection;
            }
            DefaultFeatureCollection vertexCollection = new DefaultFeatureCollection(String.valueOf(featureCollection.getID()) + "_vertex", featureType);
            vertexCollection.add(feature);
            return vertexCollection;
        }
        return featureCollection;
    }

    static boolean isClosedPolygon(List<Coordinate> coordList) {
        double firstX = coordList.get((int)0).x;
        double firstY = coordList.get((int)0).y;
        double lastX = coordList.get((int)(coordList.size() - 1)).x;
        double lastY = coordList.get((int)(coordList.size() - 1)).y;
        return firstX == lastX && firstY == lastY;
    }

    public static interface PlacemarkDescriptorProvider {
        public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType var1);
    }
}

