/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap;

import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.dataio.dimap.DimapProductWriter;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public class DimapProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String DIMAP_FORMAT_NAME = "BEAM-DIMAP";
    private final BeamFileFilter dimapFileFilter = (BeamFileFilter)DimapProductHelpers.createDimapFileFilter();
    private Set<DimapProductWriter.WriterExtender> dimapWriterWriterExtenders;

    @Override
    public String[] getFormatNames() {
        return new String[]{DIMAP_FORMAT_NAME};
    }

    @Override
    public String[] getDefaultFileExtensions() {
        return new String[]{".dim"};
    }

    @Override
    public Class[] getOutputTypes() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public String getDescription(Locale locale) {
        return "BEAM-DIMAP product writer";
    }

    @Override
    public ProductWriter createWriterInstance() {
        DimapProductWriter dimapProductWriter = new DimapProductWriter(this);
        if (this.dimapWriterWriterExtenders != null) {
            for (DimapProductWriter.WriterExtender writerExtender : this.dimapWriterWriterExtenders) {
                dimapProductWriter.addExtender(writerExtender);
            }
        }
        return dimapProductWriter;
    }

    @Override
    public BeamFileFilter getProductFileFilter() {
        return this.dimapFileFilter;
    }

    public void addWriterExtender(DimapProductWriter.WriterExtender writerExtender) {
        if (this.dimapWriterWriterExtenders == null) {
            this.dimapWriterWriterExtenders = new HashSet<DimapProductWriter.WriterExtender>();
        }
        if (writerExtender != null) {
            this.dimapWriterWriterExtenders.add(writerExtender);
        }
    }

    public void removeWriterExtender(DimapProductWriter.WriterExtender writerExtender) {
        if (this.dimapWriterWriterExtenders == null) {
            this.dimapWriterWriterExtenders.remove(writerExtender);
        }
    }
}

